/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.rendition;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.springframework.context.ApplicationContext;

public class RenditionTest
extends TestCase
implements WebSiteModel {
    private ApplicationContext appContext;
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private Repository repository;
    private ContentService contentService;
    private RenditionService renditionService;
    NodeRef companyHome;
    String testUserName;

    protected void setUp() throws Exception {
        this.appContext = ApplicationContextHelper.getApplicationContext();
        this.authenticationComponent = (AuthenticationComponent)this.appContext.getBean("authenticationComponent");
        this.transactionService = (TransactionService)this.appContext.getBean("transactionService");
        this.fileFolderService = (FileFolderService)this.appContext.getBean("fileFolderService");
        this.nodeService = (NodeService)this.appContext.getBean("nodeService");
        this.repository = (Repository)this.appContext.getBean("repositoryHelper");
        this.contentService = (ContentService)this.appContext.getBean("contentService");
        this.renditionService = (RenditionService)this.appContext.getBean("renditionService");
        this.authenticationComponent.setCurrentUser("admin");
    }

    public void testRenditionsMapedToMimetype() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        this.companyHome = this.repository.getCompanyHome();
        NodeRef webroot = this.fileFolderService.create(this.companyHome, "webroottest" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        RenditionTest.assertNotNull((Object)webroot);
        this.nodeService.setType(webroot, TYPE_WEB_ROOT);
        NodeRef section = this.fileFolderService.create(webroot, "section", ContentModel.TYPE_FOLDER).getNodeRef();
        RenditionTest.assertNotNull((Object)section);
        RenditionTest.assertEquals((Object)TYPE_SECTION, (Object)this.nodeService.getType(section));
        ArrayList<String> values = new ArrayList<String>(2);
        values.add("image/jpeg=ws:smallThumbnail");
        values.add("application/pdf=ws:smallThumbnail");
        this.nodeService.setProperty(section, PROP_RENDITION_CONFIG, (Serializable)values);
        NodeRef jpg = this.createContent(section, "test.jpg", "image/jpeg", "jpg");
        NodeRef pdf = this.createContent(section, "test.pdf", "application/pdf", "pdf");
        NodeRef text = this.createContent(section, "test.txt", "text/plain", "txt");
        NodeRef doc = this.createContent(section, "testDoc.doc", "application/msword", "doc");
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        RenditionTest.assertEquals((Object)TYPE_IMAGE, (Object)this.nodeService.getType(jpg));
        RenditionTest.assertEquals((Object)TYPE_ARTICLE, (Object)this.nodeService.getType(text));
        RenditionTest.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(pdf));
        RenditionTest.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(doc));
        RenditionTest.assertTrue((boolean)this.nodeService.hasAspect(jpg, ASPECT_WEBASSET));
        RenditionTest.assertTrue((boolean)this.nodeService.hasAspect(text, ASPECT_WEBASSET));
        RenditionTest.assertTrue((boolean)this.nodeService.hasAspect(pdf, ASPECT_WEBASSET));
        RenditionTest.assertFalse((boolean)this.nodeService.hasAspect(doc, ASPECT_WEBASSET));
        ChildAssociationRef jpgSmall = this.renditionService.getRenditionByName(jpg, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"smallThumbnail"));
        RenditionTest.assertNotNull((Object)jpgSmall);
        ChildAssociationRef jpgSmall2 = this.renditionService.getRenditionByName(pdf, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"smallThumbnail"));
        RenditionTest.assertNotNull((Object)jpgSmall2);
        NodeRef pdfDoc = this.fileFolderService.searchSimple(section, "testDoc.pdf");
        RenditionTest.assertNotNull((Object)pdfDoc);
        ChildAssociationRef jpgSmall3 = this.renditionService.getRenditionByName(pdfDoc, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"smallThumbnail"));
        RenditionTest.assertNotNull((Object)jpgSmall3);
        userTransaction.commit();
    }

    public void testRenditionsMapedToType() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        this.companyHome = this.repository.getCompanyHome();
        NodeRef webroot = this.fileFolderService.create(this.companyHome, "webroottest" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        RenditionTest.assertNotNull((Object)webroot);
        this.nodeService.setType(webroot, TYPE_WEB_ROOT);
        NodeRef section = this.fileFolderService.create(webroot, "section", ContentModel.TYPE_FOLDER).getNodeRef();
        RenditionTest.assertNotNull((Object)section);
        RenditionTest.assertEquals((Object)TYPE_SECTION, (Object)this.nodeService.getType(section));
        ArrayList<String> values = new ArrayList<String>(2);
        values.add("ws:image=ws:smallThumbnail");
        values.add("cmis:document=ws:imagePreview");
        this.nodeService.setProperty(section, PROP_RENDITION_CONFIG, (Serializable)values);
        NodeRef jpg = this.createContent(section, "test.jpg", "image/jpeg", "jpg");
        NodeRef pdf = this.createContent(section, "test.pdf", "application/pdf", "pdf");
        NodeRef text = this.createContent(section, "test.txt", "text/plain", "txt");
        NodeRef doc = this.createContent(section, "testDoc.doc", "application/msword", "doc");
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        RenditionTest.assertEquals((Object)TYPE_IMAGE, (Object)this.nodeService.getType(jpg));
        RenditionTest.assertEquals((Object)TYPE_ARTICLE, (Object)this.nodeService.getType(text));
        RenditionTest.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(pdf));
        RenditionTest.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(doc));
        RenditionTest.assertTrue((boolean)this.nodeService.hasAspect(jpg, ASPECT_WEBASSET));
        RenditionTest.assertTrue((boolean)this.nodeService.hasAspect(text, ASPECT_WEBASSET));
        RenditionTest.assertTrue((boolean)this.nodeService.hasAspect(pdf, ASPECT_WEBASSET));
        RenditionTest.assertFalse((boolean)this.nodeService.hasAspect(doc, ASPECT_WEBASSET));
        ChildAssociationRef rend1 = this.renditionService.getRenditionByName(jpg, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"smallThumbnail"));
        RenditionTest.assertNotNull((Object)rend1);
        ChildAssociationRef rend2 = this.renditionService.getRenditionByName(pdf, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"smallThumbnail"));
        RenditionTest.assertNull((Object)rend2);
        NodeRef pdfDoc = this.fileFolderService.searchSimple(section, "testDoc.pdf");
        RenditionTest.assertNotNull((Object)pdfDoc);
        ChildAssociationRef rend3 = this.renditionService.getRenditionByName(pdfDoc, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"smallThumbnail"));
        RenditionTest.assertNull((Object)rend3);
        ChildAssociationRef rend3a = this.renditionService.getRenditionByName(text, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"smallThumbnail"));
        RenditionTest.assertNull((Object)rend3a);
        ChildAssociationRef rend4 = this.renditionService.getRenditionByName(jpg, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"imagePreview"));
        RenditionTest.assertNotNull((Object)rend4);
        ChildAssociationRef rend5 = this.renditionService.getRenditionByName(pdf, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"imagePreview"));
        RenditionTest.assertNotNull((Object)rend5);
        ChildAssociationRef rend6 = this.renditionService.getRenditionByName(pdfDoc, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"imagePreview"));
        RenditionTest.assertNotNull((Object)rend6);
        ChildAssociationRef rend7 = this.renditionService.getRenditionByName(text, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"imagePreview"));
        RenditionTest.assertNotNull((Object)rend7);
        userTransaction.commit();
    }

    private NodeRef createContent(NodeRef section, String name, String mimetype, String ext) throws IOException {
        NodeRef content = this.fileFolderService.create(section, name, ContentModel.TYPE_CONTENT).getNodeRef();
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype(mimetype);
        File origFile = AbstractContentTransformerTest.loadQuickTestFile((String)ext);
        writer.putContent(origFile);
        return content;
    }
}

