/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.web.browser;

import java.net.MalformedURLException;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.web.browser.Browser;
import org.alfresco.utility.web.browser.WebBrowser;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebBrowserFactory
implements FactoryBean<WebBrowser> {
    private static final Logger LOG = LoggerFactory.getLogger(WebBrowserFactory.class);
    @Autowired
    TasProperties properties;

    public WebBrowser getWebBrowser() throws Exception {
        WebBrowser webbrowser = null;
        webbrowser = this.properties.isGridEnabled() ? new WebBrowser((WebDriver)WebBrowserFactory.getRemoteWebDriver(this.properties), this.properties) : new WebBrowser(Browser.fromProperties(this.properties), this.properties);
        if (!this.properties.getBrowserName().toLowerCase().equals("chrome") && !this.properties.isGridEnabled()) {
            webbrowser.maximize();
        }
        return webbrowser;
    }

    public Class<?> getObjectType() {
        return WebBrowser.class;
    }

    public boolean isSingleton() {
        return false;
    }

    private static RemoteWebDriver getRemoteWebDriver(TasProperties properties) throws MalformedURLException {
        LOG.info("Using RemoteWebDriver on Hub URL {}", (Object)properties.getGridUrl().toString());
        DesiredCapabilities caps = new DesiredCapabilities((Capabilities)Browser.getBrowserFromProperties(properties).getCapabilities());
        caps.setCapability("version", properties.getBrowserVersion());
        caps.setCapability("platform", properties.getEnvPlatformName());
        if (properties.getBrowserName().toLowerCase().equals("firefox")) {
            caps.setCapability("moz:firefoxOptions", (Object)Browser.setFirefoxOptions(properties));
        }
        RemoteWebDriver remoteWebDriver = new RemoteWebDriver(properties.getGridUrl(), (Capabilities)caps);
        return remoteWebDriver;
    }

    public WebBrowser getObject() throws Exception {
        return this.getWebBrowser();
    }

    public void quit() throws Exception {
        this.getWebBrowser().quit();
    }
}

