/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.web;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.web.annotation.RenderWebElement;
import org.alfresco.utility.web.browser.WebDriverAware;
import org.alfresco.utility.web.renderer.Renderer;
import org.openqa.selenium.By;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class HtmlPage
extends WebDriverAware {
    protected final Logger LOG = LoggerFactory.getLogger(HtmlPage.class);
    @Autowired
    protected TasProperties properties;

    public HtmlPage renderedPage() {
        List<Field> allFields = this.getAllDeclaredFields(new LinkedList<Field>(), this.getClass());
        for (Field field : allFields) {
            RenderWebElement[] renderWebElementArray = (RenderWebElement[])field.getAnnotationsByType(RenderWebElement.class);
            int n = renderWebElementArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] allAnnotation;
                RenderWebElement annotation;
                RenderWebElement renderAnnotation = annotation = renderWebElementArray[i];
                Renderer renderer = renderAnnotation.state().toInstance();
                for (Annotation tmpAnnotation : allAnnotation = field.getAnnotations()) {
                    FindBy[] allFindBy;
                    if (tmpAnnotation instanceof FindBy) {
                        FindBy findBy = (FindBy)tmpAnnotation;
                        renderer.render(renderAnnotation, findBy, this.browser, this.properties);
                        continue;
                    }
                    if (!(tmpAnnotation instanceof FindAll)) continue;
                    for (FindBy by : allFindBy = ((FindAll)tmpAnnotation).value()) {
                        renderer.render(renderAnnotation, by, this.browser, this.properties);
                    }
                }
            }
        }
        return this;
    }

    public String getPageTitle() {
        return this.browser.getTitle();
    }

    public void waitUntilMessageDisappears() {
        this.browser.waitUntilElementDeletedFromDom(By.cssSelector((String)"div[id='message_c'] span[class='message']"));
    }

    public void refresh() {
        this.browser.refresh();
    }
}

