/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.testrail.core;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.utility.Utility;
import org.alfresco.utility.testrail.core.TestCaseDetail;
import org.alfresco.utility.testrail.core.TestRailAPI;
import org.alfresco.utility.testrail.model.Section;
import org.alfresco.utility.testrail.model.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestResult;

public class TestRailExecutor {
    public static Logger LOG = LoggerFactory.getLogger((String)"testrail");
    private boolean isEnabled = Utility.isPropertyEnabled("testManagement.enabled");
    private boolean includeOnlyTestCasesExecuted = Utility.isPropertyEnabled("testManagement.includeOnlyTestCasesExecuted");
    private static TestRailAPI testRailAPI = new TestRailAPI();
    private static List<Section> allServerSections = new ArrayList<Section>();
    private static List<TestCase> allServerTestCases = new ArrayList<TestCase>();

    public static List<Section> getAllSection() {
        return allServerSections;
    }

    public static boolean existsInAllSection(Section section) {
        boolean exist = false;
        for (Section oldS : TestRailExecutor.getAllSection()) {
            if (section.getId() != oldS.getId()) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public static void addSections(List<Section> sections) {
        for (Section s : sections) {
            if (TestRailExecutor.existsInAllSection(s)) continue;
            TestRailExecutor.getAllSection().add(s);
        }
    }

    public static List<TestCase> getAllTestCases() {
        return allServerTestCases;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public TestCaseDetail uploadTestCase(ITestResult currentTest) {
        TestCase newTestCase = null;
        TestCaseDetail currentTestCase = new TestCaseDetail(currentTest);
        if (!currentTestCase.hasSectionCreatedIn(TestRailExecutor.getAllSection()) && currentTestCase.isMarkForUpload()) {
            testRailAPI.createNewSection(currentTestCase, TestRailExecutor.getAllSection());
        }
        for (TestCase tmpTC : TestRailExecutor.getAllTestCases()) {
            if (tmpTC.getCustom_auto_ref() == null || !tmpTC.getCustom_auto_ref().equals(currentTestCase.getId()) || tmpTC.getSection_id() != currentTestCase.getTestCaseDestination().getDestination().getId()) continue;
            newTestCase = tmpTC;
            break;
        }
        if (newTestCase == null) {
            if (currentTestCase.getElapsed() < (long)testRailAPI.getWateRateLimit()) {
                testRailAPI.waitForRateLimit();
            }
            newTestCase = testRailAPI.uploadTestCase(currentTestCase);
        }
        currentTestCase.setTestRailObject(newTestCase);
        currentTestCase.setResult(currentTest);
        return currentTestCase;
    }

    public void prepareCurrentSuiteRun() {
        TestRailExecutor.addSections(testRailAPI.getSectionsOfCurrentProject());
        allServerTestCases = testRailAPI.getAllTestCasesFromCurrentProject();
        testRailAPI.getRunOfCurrentProject();
    }

    public Object addResultsForCases(List<TestCaseDetail> currentTestCases) throws Exception {
        if (this.includeOnlyTestCasesExecuted) {
            testRailAPI.updateTestRunWithSelectedTestCases(currentTestCases);
        }
        return testRailAPI.addResultsForCases(currentTestCases);
    }
}

