/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.testrail.core;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.alfresco.utility.Utility;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.core.TestCaseDetail;
import org.alfresco.utility.testrail.model.Result;
import org.alfresco.utility.testrail.model.Run;
import org.alfresco.utility.testrail.model.RunTestCase;
import org.alfresco.utility.testrail.model.Section;
import org.alfresco.utility.testrail.model.TestCase;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRailAPI {
    static Logger LOG = LoggerFactory.getLogger((String)"testrail");
    private static final int TEMPLATE_ID = 1;
    private static final int TEST_PRIORITY_MEDIUM = 2;
    Properties properties = new Properties();
    private String username;
    private String password;
    private String endPointApiPath;
    private int currentProjectID;
    private Run currentRun = null;
    private String currentTestRunName;
    private Integer currentSuiteID;
    private String serverUrl;
    private int waitRateLimitBetweenRequests = 0;

    public TestRailAPI() {
        this.readTestRailManagementSection();
    }

    public Run getCurrentRun() {
        return this.currentRun;
    }

    public int getWateRateLimit() {
        return this.waitRateLimitBetweenRequests;
    }

    public void waitForRateLimit() {
        Utility.waitToLoopTime(this.getWateRateLimit(), "Based on Rate Limit defined in current *.properties file.");
    }

    private boolean readTestRailManagementSection() {
        boolean configurationError = true;
        InputStream defaultPropsInputStream = this.getClass().getClassLoader().getResourceAsStream(Utility.getEnvironmentPropertyFile());
        if (defaultPropsInputStream != null) {
            try {
                this.properties.load(defaultPropsInputStream);
                this.username = Utility.getSystemOrFileProperty("testManagement.username", this.properties);
                Utility.checkObjectIsInitialized(this.username, "username");
                this.password = Utility.getSystemOrFileProperty("testManagement.apiKey", this.properties);
                Utility.checkObjectIsInitialized(this.password, "password");
                this.endPointApiPath = Utility.getSystemOrFileProperty("testManagement.endPoint", this.properties) + "index.php?/api/v2/";
                Utility.checkObjectIsInitialized(this.endPointApiPath, "endPointApiPath");
                this.currentProjectID = Integer.parseInt(Utility.getSystemOrFileProperty("testManagement.project", this.properties));
                Utility.checkObjectIsInitialized(this.currentProjectID, "currentProjectID");
                this.currentTestRunName = Utility.getSystemOrFileProperty("testManagement.testRun", this.properties);
                Utility.checkObjectIsInitialized(this.currentTestRunName, "currentTestRunName");
                this.currentSuiteID = Integer.valueOf(Utility.getSystemOrFileProperty("testManagement.suiteId", this.properties));
                Utility.checkObjectIsInitialized(this.currentSuiteID, "currentSuiteID");
                this.waitRateLimitBetweenRequests = Utility.getSystemOrFileProperty("testManagement.rateLimitInSeconds", this.properties) == null ? 1 : Integer.valueOf(Utility.getSystemOrFileProperty("testManagement.rateLimitInSeconds", this.properties));
                this.serverUrl = String.format("%s://%s:%s/alfresco", Utility.getSystemOrFileProperty("alfresco.scheme", this.properties), Utility.getSystemOrFileProperty("alfresco.server", this.properties), Utility.getSystemOrFileProperty("alfresco.port", this.properties));
                configurationError = false;
            }
            catch (Exception e) {
                LOG.error("Cannot initialize Test Management Setting from default.properties file");
            }
        } else {
            LOG.error("Cannot initialize Test Management Setting from {} file", (Object)Utility.getEnvironmentPropertyFile());
        }
        return configurationError;
    }

    public List<Section> getSections(int projectID) {
        LOG.info("Query: Test Rail for all Section of currentProject [{}] defined in *.properties file", (Object)this.currentProjectID);
        try {
            Object response = this.getRequest("get_sections/" + projectID + "&suite_id=" + this.currentSuiteID);
            return this.toCollection(response, Section.class);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return new ArrayList<Section>();
        }
    }

    public List<TestCase> getAllTestCases(int projectID) {
        LOG.info("Query: Test Rail for all TestCases of currentProject [{}] defined in *.properties file", (Object)this.currentProjectID);
        try {
            Object response = this.getRequest("get_cases/" + projectID + "&suite_id=" + this.currentSuiteID);
            List<TestCase> tcs = this.toCollection(response, TestCase.class);
            LOG.info("Found #{} testcases in TestRail.", (Object)tcs.size());
            return tcs;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return new ArrayList<TestCase>();
        }
    }

    public List<Run> getRuns(int projectID) {
        LOG.info("Query: Test Rail for all Runs of currentProject [{}] defined in *.properties file", (Object)this.currentProjectID);
        try {
            Object response = this.getRequest("get_runs/" + projectID);
            return this.toCollection(response, Run.class);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return new ArrayList<Run>();
        }
    }

    protected Object getRequest(String path) throws Exception {
        URL endPointURL = new URL(this.endPointApiPath + path);
        LOG.info("TestRAILAPI: GetRequest: {}", (Object)endPointURL.toURI().toString());
        HttpURLConnection conn = (HttpURLConnection)endPointURL.openConnection();
        conn.addRequestProperty("Content-Type", "application/json");
        conn.addRequestProperty("Authorization", "Basic " + DatatypeConverter.printBase64Binary((byte[])String.format("%s:%s", this.username, this.password).getBytes()));
        return this.parseRespose(conn);
    }

    protected Object postRequest(String path, Object data) throws Exception {
        LOG.debug("TestRAILAPI: PostRequest: {}", (Object)path);
        URL endPointURL = new URL(this.endPointApiPath + path);
        HttpURLConnection conn = (HttpURLConnection)endPointURL.openConnection();
        conn.addRequestProperty("Content-Type", "application/json");
        conn.addRequestProperty("Authorization", "Basic " + DatatypeConverter.printBase64Binary((byte[])String.format("%s:%s", this.username, this.password).getBytes()));
        if (data != null) {
            byte[] block = JSONValue.toJSONString((Object)data).getBytes("UTF-8");
            conn.setDoOutput(true);
            OutputStream ostream = conn.getOutputStream();
            ostream.write(block);
            ostream.flush();
        }
        return this.parseRespose(conn);
    }

    private Object parseRespose(HttpURLConnection conn) throws Exception, IOException, UnsupportedEncodingException {
        InputStream istream;
        int status = conn.getResponseCode();
        if (status != 200) {
            istream = conn.getErrorStream();
            if (istream == null) {
                throw new Exception("TestRail API return HTTP " + status + " (No additional error message received)");
            }
        } else {
            istream = conn.getInputStream();
        }
        Object text = "";
        if (istream != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(istream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                text = (String)text + line;
                text = (String)text + System.getProperty("line.separator");
            }
            reader.close();
        }
        Object result = text != "" ? JSONValue.parse((String)text) : new JSONObject();
        if (status != 200) {
            JSONObject obj;
            Object error = "No additional error message received";
            if (result != null && result instanceof JSONObject && (obj = (JSONObject)result).containsKey((Object)"error")) {
                error = "\"" + (String)obj.get((Object)"error") + "\"";
            }
            throw new Exception("TestRail API returned HTTP " + status + "(" + (String)error + ")");
        }
        return result;
    }

    protected <T> List<T> toCollection(Object response, Class<T> classz) {
        ObjectMapper mapper = new ObjectMapper();
        List list = null;
        try {
            list = (List)mapper.readValue(response.toString(), (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, classz));
        }
        catch (JsonParseException e) {
            LOG.error(e.getMessage());
        }
        catch (JsonMappingException e) {
            LOG.error(e.getMessage());
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        return list;
    }

    public Run getRunOfCurrentProject() {
        Run r = this.getRun(this.currentTestRunName, this.currentProjectID);
        if (r == null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("suite_id", this.currentSuiteID);
            data.put("name", this.currentTestRunName);
            data.put("include_all", !Utility.isPropertyEnabled("testManagement.includeOnlyTestCasesExecuted"));
            data.put("description", "**Server:** " + this.serverUrl);
            LOG.info("Add new RUN [{}]", (Object)this.currentTestRunName);
            try {
                Object response = this.postRequest("add_run/" + this.currentProjectID, data);
                r = this.toClass(response, Run.class);
            }
            catch (Exception e) {
                LOG.error("Cannot add new section: {}", (Object)e.getMessage());
            }
        }
        this.currentRun = r;
        return r;
    }

    public Run getRun(String name, int projectID) {
        for (Run run : this.getRuns(projectID)) {
            if (!run.getName().equals(name) || run.isIs_completed()) continue;
            return run;
        }
        return null;
    }

    protected <T> T toClass(Object response, Class<T> classz) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(response.toString(), classz);
        }
        catch (JsonParseException e) {
            LOG.error(e.getMessage());
        }
        catch (JsonMappingException e) {
            LOG.error(e.getMessage());
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        return null;
    }

    public List<Section> getSectionsOfCurrentProject() {
        return this.getSections(this.currentProjectID);
    }

    public List<TestCase> getAllTestCasesFromCurrentProject() {
        return this.getAllTestCases(this.currentProjectID);
    }

    public void updateTestRunWithSelectedTestCases(List<TestCaseDetail> currentTestCases) throws Exception {
        Object results;
        HashMap<String, Serializable> testCasesData = new HashMap<String, Serializable>();
        testCasesData.put("include_all", Boolean.valueOf(false));
        ArrayList<Number> cases = new ArrayList<Number>();
        Object response = this.getRequest("get_tests/" + this.currentRun.getId());
        List<RunTestCase> runCases = this.toCollection(response, RunTestCase.class);
        for (RunTestCase runTestCase : runCases) {
            cases.add(runTestCase.getCase_id());
        }
        if (!runCases.isEmpty() && !(results = this.toCollection(response = this.getRequest("get_results_for_run/" + this.currentRun.getId()), Result.class)).isEmpty()) {
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                Result result = (Result)iterator.next();
                cases.add(result.getTest_id());
            }
        }
        for (TestCaseDetail testCaseDetail : currentTestCases) {
            cases.add(testCaseDetail.getTestRailObject().getId());
        }
        testCasesData.put("case_ids", cases);
        LOG.info("TestRAILAPI: Update Test Run: {} with only selected Test Cases of this run #{} + existing test cases already executed #{} ", new Object[]{this.currentRun.getName(), currentTestCases.size(), runCases.size()});
        try {
            response = this.postRequest("update_run/" + this.currentRun.getId(), testCasesData);
        }
        catch (Exception e1) {
            LOG.error("Cannot update RUN {} with curent test cases executed. Error: {}", (Object)this.currentRun.getName(), (Object)e1.getMessage());
        }
    }

    public Object addResultsForCases(List<TestCaseDetail> currentTestCases) throws Exception {
        HashMap data = new HashMap();
        ArrayList results = new ArrayList();
        for (TestCaseDetail tc : currentTestCases) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("case_id", tc.getTestRailObject().getId());
            result.put("status_id", tc.getStatusId());
            result.put("comment", "Executed by awesome TAS project");
            result.put("elapsed", tc.getElapsedString());
            if (tc.getBugDetails() != null) {
                result.put("defects", tc.getBugDetails().id());
                result.put("comment", tc.getBugDetails().description());
            }
            if (tc.getResult().getThrowable() != null && tc.getResult().getThrowable().getStackTrace() != null) {
                StringWriter sw = new StringWriter();
                tc.getResult().getThrowable().printStackTrace(new PrintWriter(sw));
                result.put("comment", sw.toString());
            }
            results.add(result);
        }
        data.put("results", results);
        LOG.info("TestRAILAPI: Bulk Upload [{} # total test cases] on Run: {} ", (Object)currentTestCases.size(), (Object)this.currentRun.getName());
        return this.postRequest("add_results_for_cases/" + this.currentRun.getId(), data);
    }

    public Section addNewSection(String name, Object parent_id, int projectID, int suite_id) {
        Section s = new Section();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("suite_id", suite_id);
        data.put("name", name);
        data.put("parent_id", parent_id);
        if (parent_id == null) {
            LOG.info("Add missing root section [{}]:", (Object)name);
        } else {
            LOG.info("Add missing section [{}] as child of parent section with ID: {}", (Object)name, parent_id);
        }
        try {
            Object response = this.postRequest("add_section/" + projectID, data);
            s = this.toClass(response, Section.class);
        }
        catch (Exception e) {
            LOG.error("Cannot add new section: {}", (Object)e.getMessage());
        }
        return s;
    }

    public TestCase uploadTestCase(TestCaseDetail currentTest) {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("title", currentTest.getName());
            data.put("template_id", TEMPLATE_ID);
            data.put("type_id", currentTest.getTestRailAnnotation().testType().value());
            data.put("custom_auto_ref", currentTest.getId());
            data.put("custom_executiontype", true);
            data.put("custom_test_notes", currentTest.getNotes());
            ArrayList<Integer> executionTypeList = new ArrayList<Integer>();
            for (ExecutionType et : currentTest.getTestRailAnnotation().executionType()) {
                executionTypeList.add(et.value());
            }
            data.put("custom_exce_type", executionTypeList);
            data.put("custom_description", currentTest.getTestRailAnnotation().description());
            data.put("priority_id", 2);
            data.put("custom_platform", 1);
            LOG.info("TestRAILAPI: Upload TestCase: {} to {}", (Object)currentTest.getId(), (Object)currentTest.getTestCaseDestination().toString());
            Object response = this.postRequest("add_case/" + currentTest.getTestCaseDestination().getDestination().getId(), data);
            return this.toClass(response, TestCase.class);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }

    public void createNewSection(TestCaseDetail currentTestCase, List<Section> allSections) {
        if (!currentTestCase.getTestCaseDestination().hasRootSection()) {
            Section root = this.addNewSection(currentTestCase.getTestCaseDestination().getRootSectionName(), null, this.currentProjectID, this.currentSuiteID);
            if (root.getName() == null) {
                LOG.error("Cannot add a new Section. Please check previous log WARN/ERROR !!!");
                return;
            }
            currentTestCase.getTestCaseDestination().setRootSection(root);
            allSections.add(root);
        }
        int depth = 0;
        Section parent = currentTestCase.getTestCaseDestination().getRootSection();
        if (currentTestCase.getTestCaseDestination().getChildDestinationSection().size() == 0) {
            currentTestCase.getTestCaseDestination().setDestination(parent);
        } else {
            for (String childSection : currentTestCase.getTestCaseDestination().getChildDestinationSection()) {
                if (!this.isSectionInList(++depth, parent.getId(), childSection, allSections)) {
                    Section child = this.addNewSection(childSection, parent.getId(), this.currentProjectID, this.currentSuiteID);
                    allSections.add(child);
                    parent = child;
                    currentTestCase.getTestCaseDestination().setDestination(child);
                    continue;
                }
                parent = this.getSectionInList(depth, parent.getId(), childSection, allSections);
            }
        }
    }

    private boolean isSectionInList(int depth, int parent_id, String name, List<Section> allSections) {
        boolean exists = false;
        for (Section s : allSections) {
            if (!s.getName().equals(name) || s.getDepth() != depth || s.getParent_id() != parent_id) continue;
            return true;
        }
        return exists;
    }

    private Section getSectionInList(int depth, int parent_id, String name, List<Section> allSections) {
        for (Section s : allSections) {
            if (!s.getName().equals(name) || s.getDepth() != depth || s.getParent_id() != parent_id) continue;
            return s;
        }
        return null;
    }
}

