/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.testrail;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.utility.Utility;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.utility.testrail.core.TestCaseDetail;
import org.alfresco.utility.testrail.core.TestRailExecutor;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class TestRailExecutorListener
implements ISuiteListener,
ITestListener {
    private static TestRailExecutor testRailExecutor = new TestRailExecutor();
    private static List<TestCaseDetail> currentTestCases = new ArrayList<TestCaseDetail>();

    public void onStart(ISuite suite) {
        if (testRailExecutor.isEnabled()) {
            testRailExecutor.prepareCurrentSuiteRun();
        } else {
            TestRailExecutor.LOG.warn("'TestRailExecutorListener' is added in your suite.xml file, but the property: testManagement.enabled is set to 'false' in your {} file", (Object)Utility.getEnvironmentPropertyFile());
        }
    }

    public void onFinish(ISuite suite) {
        try {
            testRailExecutor.addResultsForCases(currentTestCases);
        }
        catch (Exception e) {
            TestRailExecutor.LOG.error("CANNOT UPDATE TestCases in TestRail: {}", (Object)e.getMessage());
        }
    }

    public void onTestStart(ITestResult currentTest) {
        Step.testSteps.clear();
    }

    public void onTestSuccess(ITestResult result) {
        this.uploadTestCase(result);
    }

    public void onTestFailure(ITestResult result) {
        this.uploadTestCase(result);
    }

    public void onTestSkipped(ITestResult result) {
        this.uploadTestCase(result);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void onStart(ITestContext context) {
        Step.testSteps.clear();
    }

    public void onFinish(ITestContext context) {
    }

    private void uploadTestCase(ITestResult result) {
        TestRail annotation = result.getMethod().getConstructorOrMethod().getMethod().getAnnotation(TestRail.class);
        if (annotation != null && testRailExecutor.isEnabled()) {
            currentTestCases.add(testRailExecutor.uploadTestCase(result));
        }
    }
}

