/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.network;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.exception.ServerReachableAlfrescoIsNotRunningException;
import org.alfresco.utility.exception.ServerUnreachableException;
import org.alfresco.utility.network.TenantConsole;
import org.alfresco.utility.report.log.Step;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerHealth {
    private Logger LOG = LogFactory.getLogger();
    private static final String SERVER_VERSION_PATH = "/alfresco/service/api/server";
    private String alfrescoEdition;
    private String alfrescoVersion;
    @Autowired
    protected TasProperties properties;
    @Autowired
    private TenantConsole tenantConsole;

    public String getAlfrescoEdition() {
        return this.alfrescoEdition;
    }

    public String getAlfrescoVersion() {
        return this.alfrescoVersion;
    }

    public boolean isServerReachable(String server, int port) {
        boolean reachable = false;
        try {
            try (Socket soc = new Socket();){
                soc.connect(new InetSocketAddress(server, port), 5000);
            }
            reachable = true;
        }
        catch (IOException ex) {
            this.LOG.info("Check Alfresco Test Server: {} is Reachable, found: {}", (Object)server, (Object)ex.getMessage());
            return false;
        }
        this.LOG.info("Check Alfresco Test Server: {} is Reachable, found: {}", (Object)server, (Object)reachable);
        return reachable;
    }

    public boolean isServerReachable() {
        Step.STEP(String.format("Check the server %s is reachable", this.properties.getFullServerUrl()));
        boolean reachable = this.isServerReachable(this.properties.getServer(), this.properties.getPort());
        if (this.properties.showTenantsOnServerHealth().booleanValue()) {
            try {
                this.LOG.info("Check if there are tenants on the server: {}", (Object)this.tenantConsole.tenantExist());
            }
            catch (IOException e) {
                this.LOG.error("Exception checking if there are tenants on the server", (Throwable)e);
            }
        }
        return reachable;
    }

    public boolean isAlfrescoRunning() {
        if (!this.isServerReachable()) {
            throw new ServerUnreachableException(this.properties);
        }
        boolean isAlfrescoRunning = false;
        String alfrescoServerVersionPage = this.properties.getFullServerUrl() + SERVER_VERSION_PATH;
        this.LOG.info("Check Alfresco Test Server: {} is Online based on Admin System Summary Page {}.", (Object)this.properties.getServer(), (Object)alfrescoServerVersionPage);
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(alfrescoServerVersionPage);
            String unhashedString = String.format("%s:%s", this.properties.getAdminUser(), this.properties.getAdminPassword());
            get.setRequestHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])unhashedString.getBytes()));
            get.getParams().setSoTimeout(5000);
            client.executeMethod((HttpMethod)get);
            String response = IOUtils.toString((InputStream)get.getResponseBodyAsStream(), (String)"UTF-8");
            this.LOG.info(response.toString());
            get.releaseConnection();
            isAlfrescoRunning = response.contains("version");
            String responseEdition = response.split("\",")[0];
            String responseVersion = response.split("\",")[1];
            this.alfrescoEdition = responseEdition.substring(responseEdition.lastIndexOf("\"") + 1);
            this.alfrescoVersion = responseVersion.substring(responseVersion.lastIndexOf("\"") + 1);
        }
        catch (Exception ex) {
            this.LOG.error("Cannot GET {} page. Exception: {} ", (Object)alfrescoServerVersionPage, (Object)ex.getMessage());
            isAlfrescoRunning = false;
        }
        return isAlfrescoRunning;
    }

    public void assertServerIsOnline() {
        if (!this.isAlfrescoRunning()) {
            throw new ServerReachableAlfrescoIsNotRunningException(this.properties);
        }
    }
}

