/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.network;

import java.io.IOException;
import java.io.InputStream;
import javax.management.ObjectName;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.exception.EnvironmentConfigurationException;
import org.alfresco.utility.network.Jmx;
import org.alfresco.utility.network.JmxClient;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pExecResponse;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pResponse;
import org.jolokia.client.request.J4pWriteRequest;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JmxJolokiaProxyClient
implements Jmx {
    private static Logger LOG = LogFactory.getLogger();
    @Autowired
    protected TasProperties properties;
    private J4pClient client;

    @Override
    public Object readProperty(String objectName, String attributeName) throws Exception {
        J4pReadRequest request = new J4pReadRequest(objectName, new String[]{attributeName});
        J4pReadResponse response = (J4pReadResponse)this.executeRequest((J4pRequest)request);
        LOG.info("JMX Object [{}] with attribute [{}]", (Object)objectName, (Object)attributeName);
        return response.getValue().toString();
    }

    @Override
    public Object writeProperty(String objectName, String attributeName, Object attributeValue) throws Exception {
        J4pWriteRequest requestW = new J4pWriteRequest(objectName, attributeName, attributeValue, new String[]{""});
        J4pResponse response = this.getClient().execute((J4pRequest)requestW);
        LOG.info("Updating objectName {}.{} with value {} via JmxJolokia", new Object[]{objectName, attributeName, attributeValue});
        this.refreshServerProperty(objectName, JmxClient.JmxPropertyOperation.stop);
        this.refreshServerProperty(objectName, JmxClient.JmxPropertyOperation.start);
        return response.getValue();
    }

    public void refreshServerProperty(String objectName, JmxClient.JmxPropertyOperation operation) throws Exception {
        ObjectName objectJmx = new ObjectName(objectName);
        J4pExecRequest j4pExecRequest = new J4pExecRequest(objectJmx, operation.toString(), new Object[0]);
        this.getClient().execute((J4pRequest)j4pExecRequest);
    }

    private J4pResponse<?> executeRequest(J4pRequest request) throws Exception {
        J4pResponse response;
        try {
            response = this.getClient().execute(request);
        }
        catch (J4pRemoteException e) {
            throw new EnvironmentConfigurationException("It seems Jolokia agent was not installed on test environment or missconfigured. Error thrown: " + e.getMessage());
        }
        return response;
    }

    public J4pClient getClient() {
        if (this.client == null) {
            this.client = new J4pClient(this.getJolokiaAgentServerUrlPath());
        }
        return this.client;
    }

    public String getJolokiaAgentServerUrlPath() {
        return String.format("%s/jolokia", this.properties.getFullServerUrl());
    }

    @Override
    public boolean isJMXEnabled() {
        boolean isEnabled = false;
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(this.getJolokiaAgentServerUrlPath());
        get.setDoAuthentication(false);
        get.getParams().setSoTimeout(5000);
        try {
            client.executeMethod((HttpMethod)get);
            String response = IOUtils.toString((InputStream)get.getResponseBodyAsStream(), (String)"UTF-8");
            isEnabled = response.contains("agentId");
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        get.releaseConnection();
        return isEnabled;
    }

    @Override
    public Object executeJMXMethod(String objectName, String methodName, Object ... pArgs) throws Exception {
        J4pExecRequest request = new J4pExecRequest(objectName, methodName, pArgs);
        J4pExecResponse response = (J4pExecResponse)this.executeRequest((J4pRequest)request);
        LOG.info("Executing methodName {} on objectName {} via JmxJolokia", (Object)methodName, (Object)objectName);
        return response.getValue();
    }
}

