/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.TasProperties;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class HttpConsoleOperation {
    @Autowired
    protected TasProperties properties;
    protected static Logger LOG = LogFactory.getLogger();
    protected String relativePath;
    private CloseableHttpClient httpclient;

    public CloseableHttpClient getHttpClient() {
        return this.httpclient;
    }

    public HttpConsoleOperation(String relativePath) {
        this.relativePath = relativePath;
        this.httpclient = HttpClients.createDefault();
    }

    protected String getAlfrescoConsolePath() {
        return this.properties.getFullServerUrl() + this.relativePath;
    }

    protected String getAdminBasicAuthentication() {
        String unhashedString = String.format("%s:%s", this.properties.getAdminUser(), this.properties.getAdminPassword());
        return "Basic " + Base64.encodeBase64String((byte[])unhashedString.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element execute(BasicNameValuePair command) throws IOException {
        HttpPost httpPost = new HttpPost(this.getAlfrescoConsolePath());
        httpPost.addHeader("Authorization", this.getAdminBasicAuthentication());
        ArrayList<BasicNameValuePair> commands = new ArrayList<BasicNameValuePair>();
        commands.add(command);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(commands));
        try (CloseableHttpResponse postResponse = this.getHttpClient().execute((HttpUriRequest)httpPost);){
            LOG.info("Executing command: {} -> Response: {}", commands, (Object)postResponse.getStatusLine());
            HttpEntity postEntity = postResponse.getEntity();
            EntityUtils.consume((HttpEntity)postEntity);
        }
        return this.parsedResponse();
    }

    protected Document fullResponseDocument() throws IOException {
        URL url = new URL(this.getAlfrescoConsolePath());
        URLConnection uc = url.openConnection();
        uc.setRequestProperty("X-Requested-With", "TAS-Client");
        uc.setRequestProperty("Authorization", this.getAdminBasicAuthentication());
        Object fullPage = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                fullPage = (String)fullPage + line;
            }
        }
        return Jsoup.parse((String)((String)fullPage).toString());
    }

    protected Element parsedResponse() throws IOException {
        Element last = this.fullResponseDocument().select("div.column-full").last();
        LOG.info("Response: {}", (Object)last.toString());
        return last;
    }
}

