/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.Model;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;

public abstract class TestModel
implements Model {
    static Logger LOG = LogFactory.getLogger();

    @Override
    public String toInfo() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public String toString() {
        return String.format("\n%s", this.toInfo());
    }

    public String toJson() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonGenerationException e) {
            return e.toString();
        }
        catch (JsonMappingException e) {
            return e.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    protected static void setRandomValuesForAllFields(TestModel testModel, String ... ignoredFields) {
        List<Field> allFields = TestModel.getAllDeclaredFields(new LinkedList<Field>(), testModel.getClass());
        for (Field field : allFields) {
            if (field.isAnnotationPresent(JsonProperty.class) && field.getAnnotation(JsonProperty.class).value().equals("entry") || Arrays.asList(ignoredFields).contains(field.getName())) continue;
            try {
                field.setAccessible(true);
                if (field.getType().equals(List.class)) {
                    ArrayList<String> newListValue = new ArrayList<String>();
                    newListValue.add(RandomData.getRandomAlphanumeric());
                    newListValue.add(RandomData.getRandomAlphanumeric());
                    field.set(testModel, newListValue);
                    continue;
                }
                if (TestModel.class.isAssignableFrom(field.getType())) {
                    Object model = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    TestModel.setRandomValuesForAllFields((TestModel)model, new String[0]);
                    field.set(testModel, model);
                    continue;
                }
                if (field.getType().equals(Boolean.TYPE)) {
                    field.set(testModel, true);
                    continue;
                }
                if (field.getName().toLowerCase().endsWith("at")) {
                    field.set(testModel, "2017-01-01T15:16:31.000+0000");
                    continue;
                }
                if (!field.getType().equals(String.class)) continue;
                field.set(testModel, field.getName() + RandomStringUtils.randomAlphabetic((int)3));
            }
            catch (Exception e) {
                throw new DataPreparationException(e);
            }
        }
    }

    private static List<Field> getAllDeclaredFields(List<Field> fields, Class<?> classz) {
        if (classz.isAssignableFrom(TestModel.class)) {
            return fields;
        }
        fields.addAll(Arrays.asList(classz.getDeclaredFields()));
        if (classz.getSuperclass() != null) {
            fields = TestModel.getAllDeclaredFields(fields, classz.getSuperclass());
        }
        return fields;
    }
}

