/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.exception.IORuntimeException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileType;
import org.testng.reporters.Files;

public class FileModel
extends ContentModel {
    private String content = "";
    private FileType fileType;

    public FileModel() {
    }

    public FileModel(String name) {
        super(name);
        this.setFileType(FileType.fromName(name));
    }

    public FileModel(String name, FileType fileType) {
        super(name);
        this.setFileType(fileType);
    }

    public FileModel(String name, String title, String description, FileType fileType) {
        super(name, title, description);
        this.setFileType(fileType);
    }

    public FileModel(String name, FileType fileType, String content) {
        this(name, fileType);
        this.setContent(content);
    }

    public FileModel(String name, String title, String description, FileType fileType, String content) {
        this(name, title, description, fileType);
        this.setContent(content);
    }

    public FileModel(FileModel originalFile) {
        this(originalFile.getName(), originalFile.getTitle(), originalFile.getDescription(), originalFile.getFileType(), originalFile.getContent());
        this.setCmisLocation(originalFile.getCmisLocation());
        this.setProtocolLocation(originalFile.getProtocolLocation());
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public FileType getFileType() {
        if (this.fileType == null) {
            this.fileType = FileType.TEXT_PLAIN;
        }
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public static FileModel getRandomFileModel(FileType fileType) {
        FileModel newFileModel = new FileModel(RandomData.getRandomFile(fileType));
        LOG.info("Generating new FileModel: {}", (Object)newFileModel.toString());
        return newFileModel;
    }

    public static FileModel getRandomFileModel(FileType fileType, String content) {
        FileModel newFileModel = new FileModel(RandomData.getRandomFile(fileType));
        newFileModel.setContent(content);
        LOG.info("Generating new FileModel: {}", (Object)newFileModel.toString());
        return newFileModel;
    }

    public File toFile() {
        return new File(this.getName());
    }

    public static FileModel getFileModelBasedOnTestDataFile(String resourceDataFile) {
        File tmp = Utility.getResourceTestDataFile(resourceDataFile);
        FileModel testFile = new FileModel(tmp.getPath(), FileType.fromName(tmp.getName()));
        testFile.setCmisLocation(tmp.getName());
        try {
            String content = Files.readFile((InputStream)new FileInputStream(tmp)).replace("\n", "");
            testFile.setContent(content);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return testFile;
    }

    public FileModel cloneAsWorkingCopy() {
        FileModel workingCopy = new FileModel();
        String type = FileType.fromName((String)this.getName()).extension;
        String nameNoType = this.getName().replace("." + type, "");
        String workingCopyName = nameNoType + " (Working Copy)." + type;
        workingCopy.setName(workingCopyName);
        workingCopy.setFileType(FileType.fromName(this.getName()));
        workingCopy.setContent(this.getContent());
        workingCopy.setCmisLocation(this.getCmisLocation().replace(this.getName(), workingCopyName));
        workingCopy.setProtocolLocation(this.getProtocolLocation().replace(this.getName(), workingCopyName));
        return workingCopy;
    }

    public static FileModel getFileModelWithContentSizeOfxMB(int size) {
        FileModel contentModel = new FileModel(RandomData.getRandomName("file"), FileType.TEXT_PLAIN);
        contentModel.setContent(new String(new char[0x100000 * size]));
        return contentModel;
    }
}

