/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.provider;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.provider.XMLAspectData;
import org.alfresco.utility.data.provider.XMLCollection;
import org.alfresco.utility.data.provider.XMLCommentData;
import org.alfresco.utility.data.provider.XMLDataItem;
import org.alfresco.utility.data.provider.XMLFileData;
import org.alfresco.utility.data.provider.XMLFolderData;
import org.alfresco.utility.data.provider.XMLSiteData;
import org.alfresco.utility.data.provider.XMLTagData;
import org.alfresco.utility.data.provider.XMLUserData;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.QueryModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TestModel;
import org.alfresco.utility.model.UserModel;
import org.slf4j.Logger;

@XmlRootElement(name="testData")
public class XMLTestData
extends XMLCollection {
    static Logger LOG = LogFactory.getLogger();
    private List<QueryModel> queries;
    private List<XMLSiteData> sites = new ArrayList<XMLSiteData>();
    private List<XMLUserData> users;

    @XmlElementWrapper
    @XmlElement(name="query")
    public List<QueryModel> getQueries() {
        return this.queries;
    }

    public void setQueries(List<QueryModel> queries) {
        this.queries = queries;
    }

    @XmlElementWrapper
    @XmlElement(name="site")
    public List<XMLSiteData> getSites() {
        return this.sites;
    }

    public void setSites(List<XMLSiteData> sites) {
        this.sites = sites;
    }

    @XmlElementWrapper
    @XmlElement(name="user")
    public List<XMLUserData> getUsers() {
        return this.users;
    }

    public void setUsers(List<XMLUserData> users) {
        this.users = users;
    }

    public void createUsers(DataUser dataUser) throws DataPreparationException {
        for (XMLUserData user : this.getUsers()) {
            if (dataUser.isUserInRepo(user.getName())) {
                LOG.info("Skipping USER data:{}. This user already exists in repository!", (Object)user.toString());
                continue;
            }
            LOG.info("Creating USER data:" + user.toString());
            dataUser.createUser(user.getName(), user.getPassword());
        }
        this.logEntireStructure();
    }

    public void createSitesStructure(DataSite dataSite, DataContent dataContent, DataUser dataUser) {
        for (XMLSiteData site : this.getSites()) {
            if (((DataSite)dataSite.usingAdmin()).isSiteCreated(site.getModel())) {
                LOG.info("Skipping Site: {}. This site already exists in repository!", (Object)site.getFullLocation());
            } else {
                LOG.info("Creating Site: {}", (Object)site.getFullLocation());
                UserModel user = this.getUserBy(dataContent.getAdminUser(), site.getCreatedBy());
                ((DataSite)dataSite.usingUser(user)).createSite(site.getModel());
            }
            this.addMembers(site.getMembers(), site.getModel(), dataUser);
            this.createFilesStructure(site.getFiles(), site.getModel(), dataContent);
            this.createFolderStructure(site.getFolders(), site.getFullLocation(), dataContent);
        }
    }

    private void createFolderStructure(List<XMLFolderData> folderStructure, String location, DataContent dataContent) {
        for (XMLFolderData folder : folderStructure) {
            FolderModel folderInRepo;
            UserModel userFolder = this.getUserBy(dataContent.getAdminUser(), folder.getCreatedBy());
            if (folder.isCustomModel()) {
                LOG.info("Creating Custom Folder: {}", (Object)folder.getModel().toString());
                folderInRepo = (FolderModel)((DataContent)dataContent.usingUser(userFolder).setCurrentSpace(location)).createCustomContent(folder.getModel(), folder.getCustomModel().getName(), folder.getCustomModel().getObjectTypeProperties());
            } else {
                folderInRepo = ((DataContent)dataContent.usingUser(userFolder).setCurrentSpace(location)).createFolder(folder.getModel(), false);
            }
            this.addAspects(folder, folder.getAspects(), dataContent);
            this.addComments(folderInRepo.getCmisLocation(), folder.getComments(), dataContent);
            this.addTags(folderInRepo.getCmisLocation(), folder.getTags(), dataContent);
            this.createFilesStructure(folder.getFiles(), folderInRepo, dataContent);
            this.createFolderStructure(folder.getFolders(), folderInRepo.getCmisLocation(), dataContent);
        }
    }

    private void createFilesStructure(List<XMLFileData> filesStructure, TestModel parentFolder, DataContent dataContent) {
        for (XMLFileData file : filesStructure) {
            UserModel userFile = this.getUserBy(dataContent.getAdminUser(), file.getCreatedBy());
            ContentModel contentInRepo = null;
            if (parentFolder instanceof FolderModel) {
                FolderModel parentFolderInCmis = (FolderModel)parentFolder;
                if (file.isCustomModel()) {
                    ((DataContent)dataContent.usingUser(userFile).usingResource(parentFolderInCmis)).setCurrentSpace(parentFolderInCmis.getCmisLocation());
                    contentInRepo = (FileModel)dataContent.createCustomContent(file.getModel(), file.getCustomModel().getName(), file.getCustomModel().getObjectTypeProperties());
                } else {
                    ((DataContent)dataContent.usingUser(userFile).usingResource(parentFolderInCmis)).setCurrentSpace(parentFolderInCmis.getCmisLocation());
                    contentInRepo = dataContent.usingUser(userFile).createContent(file.getModel());
                }
            }
            if (parentFolder instanceof SiteModel) {
                contentInRepo = file.isCustomModel() ? (FileModel)((DataContent)dataContent.usingUser(userFile).usingSite((SiteModel)parentFolder)).createCustomContent(file.getModel(), file.getCustomModel().getName(), file.getCustomModel().getObjectTypeProperties()) : ((DataContent)dataContent.usingUser(userFile).usingSite((SiteModel)parentFolder)).createContent(file.getModel());
            }
            this.addAspects(file, file.getAspects(), dataContent);
            this.addComments(contentInRepo.getCmisLocation(), file.getComments(), dataContent);
            this.addTags(contentInRepo.getCmisLocation(), file.getTags(), dataContent);
        }
    }

    public void cleanup(DataContent dataContent) throws TestConfigurationException {
        LOG.info("Starting CLEANUP process...");
        for (XMLSiteData site : this.getSites()) {
            for (XMLFolderData folder : site.getFolders()) {
                dataContent.usingAdmin().deleteTree(folder.getModel());
            }
            for (XMLFileData file : site.getFiles()) {
                if (!dataContent.checkContent(file.getModel().getCmisLocation(), dataContent.getAdminUser())) continue;
                try {
                    ((DataContent)dataContent.usingAdmin().usingResource(file.getModel())).deleteContent();
                }
                catch (Exception e) {
                    LOG.error("Could not delete file: {}", (Object)file.getModel().toString());
                }
            }
            dataContent.usingAdmin().deleteSite(site.getModel());
        }
        dataContent.emptyUserTrashcan(dataContent.getAdminUser());
        try {
            FileModel customModel = dataContent.getCustomModel();
            if (customModel != null) {
                ((DataContent)dataContent.usingAdmin().usingResource(customModel)).deleteContent();
                dataContent.emptyUserTrashcan(dataContent.getAdminUser());
            } else {
                LOG.info("Custom Model not found!");
            }
        }
        catch (Exception e) {
            LOG.error("Ignoring failure to delete custom model file.", (Throwable)e);
        }
        LOG.info("CLEANUP finished!");
    }

    private UserModel getUserBy(UserModel admin, String userIdFromXMLFile) throws DataPreparationException {
        if (userIdFromXMLFile.toLowerCase().equals("admin")) {
            return admin;
        }
        UserModel user = null;
        for (XMLUserData u : this.users) {
            if (!u.getId().equals(userIdFromXMLFile)) continue;
            user = u.getModel();
            break;
        }
        if (user == null) {
            String info = String.format("You want to use user with ID [%s] but this wasn't specified in <users> section in your xml file.", userIdFromXMLFile);
            throw new DataPreparationException(info);
        }
        return user;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("xmlFileInputData-PREPARING[users=").append(this.getUsers().size()).append(", sites=").append(this.getSites().size()).append("]");
        return info.toString();
    }

    private void addMembers(List<XMLUserData> membersStructure, SiteModel siteModel, DataUser dataUser) {
        for (XMLUserData user : membersStructure) {
            UserModel userFile = this.getUserBy(dataUser.getAdminUser(), user.getId());
            dataUser.addUserToSite(userFile, siteModel, UserRole.valueOf(user.getRole()));
        }
    }

    private void addComments(String objectPathInCmis, List<XMLCommentData> comments, DataContent dataContent) throws DataPreparationException {
        if (comments.size() > 0) {
            LOG.info("Adding Comments Count: {} to object: {}", (Object)comments.size(), (Object)objectPathInCmis);
        }
        for (XMLCommentData comment : comments) {
            UserModel userComment = this.getUserBy(dataContent.getAdminUser(), comment.getCreatedBy());
            dataContent.getContentActions().addComment(userComment.getUsername(), userComment.getPassword(), objectPathInCmis, comment.getValue());
        }
    }

    private void addTags(String objectPathInCmis, List<XMLTagData> tags, DataContent dataContent) {
        if (tags.size() > 0) {
            LOG.info("Adding Tags Count: {} to object: {}", (Object)tags.size(), (Object)objectPathInCmis);
        }
        for (XMLTagData tag : tags) {
            UserModel userTag = this.getUserBy(dataContent.getAdminUser(), tag.getCreatedBy());
            ((DataContent)dataContent.usingUser(userTag).setLastResource(objectPathInCmis)).addTagToContent(tag.getModel());
        }
    }

    private void addAspects(XMLDataItem dataItem, List<XMLAspectData> aspects, DataContent dataContent) throws DataPreparationException {
        if (aspects.size() > 0) {
            LOG.info("Adding Aspects Count: {} to object: {}", (Object)aspects.size(), (Object)dataItem.getModel().toString());
            if (dataItem instanceof XMLFolderData) {
                XMLFolderData f = (XMLFolderData)dataItem;
                UserModel user = this.getUserBy(dataContent.getAdminUser(), f.getCreatedBy());
                ((DataContent)dataContent.usingUser(user).setLastResource(f.getModel().getCmisLocation())).addAspect(aspects);
            } else if (dataItem instanceof XMLFileData) {
                XMLFileData f = (XMLFileData)dataItem;
                UserModel user = this.getUserBy(dataContent.getAdminUser(), f.getCreatedBy());
                ((DataContent)dataContent.usingUser(user).setLastResource(f.getModel().getCmisLocation())).addAspect(aspects);
            }
        }
    }

    @Override
    protected List<XMLDataItem> getImbricatedData() {
        this.entireStructure.addAll(this.getUsers());
        for (XMLSiteData site : this.getSites()) {
            this.entireStructure.addAll(site.getEntireStructure());
        }
        return this.entireStructure;
    }

    public void logEntireStructure() {
        LOG.info("Summarizing the Test Data Structure:");
        for (XMLDataItem item : this.getEntireStructure()) {
            LOG.info("Found Test Data Model [{}] with -> id [{}], info: {}", new Object[]{item.getClass(), item.getId(), item.toString()});
        }
    }

    public XMLDataItem getTestDataItemWithId(String id) {
        LOG.info("Searching for Test Data Item with id: {}", (Object)id);
        XMLDataItem dataFound = null;
        for (XMLDataItem item : this.getEntireStructure()) {
            if (item.getId() == null) {
                LOG.error("Test Data Item  [{}] does not have id assigned", (Object)item.toString());
                continue;
            }
            if (!item.getId().equals(id)) continue;
            dataFound = item;
            break;
        }
        Utility.checkObjectIsInitialized(dataFound, "It seems you don't have a Test Data with ID " + id + " in your input xml file.");
        return dataFound;
    }
}

