/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.provider;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.alfresco.dataprep.SiteService;
import org.alfresco.utility.data.provider.XMLCollection;
import org.alfresco.utility.data.provider.XMLDataItem;
import org.alfresco.utility.data.provider.XMLFileData;
import org.alfresco.utility.data.provider.XMLFolderData;
import org.alfresco.utility.data.provider.XMLUserData;
import org.alfresco.utility.model.SiteModel;

@XmlType(name="site")
public class XMLSiteData
extends XMLCollection
implements XMLDataItem {
    private String name;
    private String createdBy;
    private String visibility;
    private String id;
    private List<XMLFolderData> folders = new ArrayList<XMLFolderData>();
    private List<XMLFileData> files = new ArrayList<XMLFileData>();
    private List<XMLUserData> members = new ArrayList<XMLUserData>();
    private SiteModel model = new SiteModel();

    @XmlAttribute(name="visibility")
    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public String getFullLocation() {
        return String.format("/Sites/%s/documentLibrary", this.getName());
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @XmlElementWrapper
    @XmlElement(name="folder")
    public List<XMLFolderData> getFolders() {
        for (XMLFolderData f : this.folders) {
            f.setParent(this.getFullLocation());
        }
        return this.folders;
    }

    public void setFolders(List<XMLFolderData> folders) {
        this.folders = folders;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("site[name='").append(this.getName()).append("',").append("createdBy='").append(this.getCreatedBy()).append("']");
        return info.toString();
    }

    @Override
    public SiteModel getModel() {
        this.model.setId(this.getName());
        this.model.setTitle(this.getName());
        SiteService.Visibility v = SiteService.Visibility.PUBLIC;
        switch (this.getVisibility()) {
            case "public": {
                v = SiteService.Visibility.PUBLIC;
                break;
            }
            case "private": {
                v = SiteService.Visibility.PRIVATE;
            }
        }
        this.model.setVisibility(v);
        return this.model;
    }

    @XmlElementWrapper
    @XmlElement(name="file")
    public List<XMLFileData> getFiles() {
        for (XMLFileData f : this.files) {
            f.setParent(this.getFullLocation());
        }
        return this.files;
    }

    public void setFiles(List<XMLFileData> files) {
        for (XMLFileData f : files) {
            f.setParent(this.getFullLocation());
        }
        this.files = files;
    }

    @XmlElementWrapper
    @XmlElement(name="user")
    public List<XMLUserData> getMembers() {
        return this.members;
    }

    public void setMembers(List<XMLUserData> members) {
        this.members = members;
    }

    @Override
    @XmlAttribute(name="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    protected List<XMLDataItem> getImbricatedData() {
        this.entireStructure.add(this);
        this.entireStructure.addAll(this.getMembers());
        for (XMLFileData file : this.getFiles()) {
            file.setParent(this.getFullLocation());
            this.entireStructure.addAll(file.getEntireStructure());
        }
        for (XMLFolderData folder : this.getFolders()) {
            folder.setParent(this.getFullLocation());
            this.entireStructure.addAll(folder.getEntireStructure());
        }
        return this.entireStructure;
    }
}

