/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.provider;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.alfresco.utility.data.CustomObjectTypeProperties;
import org.alfresco.utility.data.provider.XMLPropertyData;

@XmlType(name="custom-model")
public class XMLCustomModel {
    private String name;
    private String id;
    private List<XMLPropertyData> properties = new ArrayList<XMLPropertyData>();

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElementWrapper
    @XmlElement(name="property")
    public List<XMLPropertyData> getProperties() {
        return this.properties;
    }

    public void setProperties(List<XMLPropertyData> properties) {
        this.properties = properties;
    }

    public CustomObjectTypeProperties getObjectTypeProperties() {
        CustomObjectTypeProperties customProps = new CustomObjectTypeProperties();
        for (XMLPropertyData p : this.properties) {
            try {
                int value = Integer.parseInt(p.getValue());
                customProps.addProperty(p.getName(), value);
            }
            catch (NumberFormatException e) {
                customProps.addProperty(p.getName(), p.getValue());
            }
        }
        return customProps;
    }

    @XmlAttribute(name="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("custom-model[name='").append(this.getName()).append("',").append("id='").append(this.getId()).append("']");
        return info.toString();
    }
}

