/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.auth;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.data.auth.DataLDAP;
import org.alfresco.utility.data.auth.UserManageable;
import org.alfresco.utility.exception.TestStepException;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.testng.Assert;

@Service
@Scope(value="prototype")
public class DataKerberos {
    @Autowired
    private TasProperties tasProperties;
    private static final String USER_SEARCH_BASE = "CN=%s,CN=Users,DC=alfresconess,DC=com";
    private DirContext context;

    public Builder perform() throws NamingException {
        return new Builder();
    }

    public class Builder
    implements UserManageable {
        public Builder() throws NamingException {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", DataKerberos.this.tasProperties.getAuthContextFactory());
            properties.put("java.naming.provider.url", DataKerberos.this.tasProperties.getLdapURL());
            properties.put("java.naming.security.authentication", DataKerberos.this.tasProperties.getSecurityAuth());
            properties.put("java.naming.security.principal", DataKerberos.this.tasProperties.getLdapSecurityPrincipal());
            properties.put("java.naming.security.credentials", DataKerberos.this.tasProperties.getLdapSecurityCredentials());
            DataKerberos.this.context = new InitialDirContext(properties);
        }

        @Override
        public Builder createUser(UserModel user) throws NamingException, UnsupportedEncodingException {
            Step.STEP(String.format("[Kerberos] Add user %s", user.getUsername()));
            BasicAttributes attributes = new BasicAttributes();
            BasicAttribute objectClass = new BasicAttribute("objectClass", DataLDAP.ObjectType.user.toString());
            BasicAttribute sn = new BasicAttribute("sn", user.getLastName());
            BasicAttribute samAccountName = new BasicAttribute("samAccountName", user.getUsername());
            BasicAttribute userAccountControl = new BasicAttribute("userAccountControl");
            userAccountControl.add(Integer.toString(UserAccountStatus.NORMAL_ACCOUNT.getValue() + UserAccountStatus.PASSWD_NOTREQD.getValue() + UserAccountStatus.DONT_EXPIRE_PASSWD.getValue() + UserAccountStatus.TRUSTED_TO_AUTH_FOR_DELEGATION.getValue() + UserAccountStatus.DONT_REQ_PREAUTH.getValue()));
            attributes.put(objectClass);
            attributes.put(sn);
            attributes.put(samAccountName);
            attributes.put(userAccountControl);
            DataKerberos.this.context.createSubcontext(String.format(DataKerberos.USER_SEARCH_BASE, user.getUsername()), (Attributes)attributes);
            String newQuotedPassword = String.format("\"%s\"", user.getPassword());
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", newUnicodePassword)), new ModificationItem(2, new BasicAttribute("userAccountControl", Integer.toString(UserAccountStatus.NORMAL_ACCOUNT.getValue() + UserAccountStatus.DONT_EXPIRE_PASSWD.getValue() + UserAccountStatus.TRUSTED_TO_AUTH_FOR_DELEGATION.getValue() + UserAccountStatus.DONT_REQ_PREAUTH.getValue())))};
            DataKerberos.this.context.modifyAttributes(String.format(DataKerberos.USER_SEARCH_BASE, user.getUsername()), mods);
            return this;
        }

        public SearchResult searchForObjectClass(String name, DataLDAP.ObjectType typeOfClass) throws NamingException {
            NamingEnumeration<SearchResult> results = null;
            String searchFilter = String.format("(objectClass=%s)", typeOfClass.toString());
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            try {
                results = DataKerberos.this.context.search(String.format(DataKerberos.USER_SEARCH_BASE, name), searchFilter, searchControls);
            }
            catch (NameNotFoundException e) {
                return null;
            }
            if (results.hasMoreElements()) {
                return (SearchResult)results.nextElement();
            }
            return null;
        }

        @Override
        public UserManageable deleteUser(UserModel user) throws NamingException {
            Step.STEP(String.format("[Kerberos] Delete user %s", user.getUsername()));
            DataKerberos.this.context.destroySubcontext(String.format(DataKerberos.USER_SEARCH_BASE, user.getUsername()));
            return this;
        }

        @Override
        public UserManageable updateUser(UserModel user, HashMap<String, String> attributes) throws NamingException, UnsupportedEncodingException {
            Step.STEP(String.format("[Kerberos] Update user %s", user.getUsername()));
            ModificationItem[] items = new ModificationItem[attributes.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                BasicAttribute attribute = new BasicAttribute(entry.getKey());
                if (entry.getKey().equals("unicodePwd")) {
                    String newQuotedPassword = String.format("\"%s\"", entry.getValue());
                    byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
                    attribute.add(newUnicodePassword);
                } else {
                    attribute.add(entry.getValue());
                }
                items[i] = new ModificationItem(2, attribute);
                ++i;
            }
            DataKerberos.this.context.modifyAttributes(String.format(DataKerberos.USER_SEARCH_BASE, user.getUsername()), items);
            return this;
        }

        public Builder disableUser(UserModel user) throws NamingException {
            Step.STEP(String.format("[Kerberos] Disable user %s", user.getUsername()));
            BasicAttribute memberAttribute = new BasicAttribute("userAccountControl", Integer.toString(UserAccountStatus.DISABLE_ACCOUNT.getValue() + UserAccountStatus.NORMAL_ACCOUNT.getValue() + UserAccountStatus.DONT_EXPIRE_PASSWD.getValue() + UserAccountStatus.TRUSTED_TO_AUTH_FOR_DELEGATION.getValue() + UserAccountStatus.DONT_REQ_PREAUTH.getValue()));
            ModificationItem[] modification = new ModificationItem[]{new ModificationItem(2, memberAttribute)};
            DataKerberos.this.context.modifyAttributes(String.format(DataKerberos.USER_SEARCH_BASE, user.getUsername()), modification);
            return this;
        }

        public Builder enableUser(UserModel user) throws NamingException {
            Step.STEP(String.format("[Kerberos] Enable user %s", user.getUsername()));
            BasicAttribute memberAttribute = new BasicAttribute("userAccountControl", Integer.toString(UserAccountStatus.NORMAL_ACCOUNT.getValue() + UserAccountStatus.DONT_EXPIRE_PASSWD.getValue() + UserAccountStatus.TRUSTED_TO_AUTH_FOR_DELEGATION.getValue() + UserAccountStatus.DONT_REQ_PREAUTH.getValue()));
            ModificationItem[] modification = new ModificationItem[]{new ModificationItem(2, memberAttribute)};
            DataKerberos.this.context.modifyAttributes(String.format(DataKerberos.USER_SEARCH_BASE, user.getUsername()), modification);
            return this;
        }

        @Override
        public UserManageable assertUserExists(UserModel user) throws NamingException {
            Step.STEP(String.format("[Kerberos] Assert user %s exists", user.getUsername()));
            Assert.assertNotNull((Object)this.searchForObjectClass(user.getUsername(), DataLDAP.ObjectType.user));
            return this;
        }

        @Override
        public UserManageable assertUserDoesNotExist(UserModel user) throws NamingException, TestStepException {
            Step.STEP(String.format("[Kerberos] Assert user %s does not exist", user.getUsername()));
            Assert.assertNull((Object)this.searchForObjectClass(user.getUsername(), DataLDAP.ObjectType.user));
            return this;
        }

        public Builder assertUserIsDisabled(UserModel user, UserAccountControlValue userAccountControlValue) throws NamingException {
            Attributes accountStatus = DataKerberos.this.context.getAttributes(String.format(DataKerberos.USER_SEARCH_BASE, user.getUsername()), new String[]{"userAccountControl"});
            Assert.assertTrue((boolean)accountStatus.toString().contains(userAccountControlValue.toString()), (String)String.format("User account control value expected %s but found %s", userAccountControlValue.toString(), accountStatus.toString()));
            return this;
        }

        public Builder assertUserIsEnabled(UserModel user, UserAccountControlValue userAccountControlValue) throws NamingException {
            Attributes accountStatus = DataKerberos.this.context.getAttributes(String.format(DataKerberos.USER_SEARCH_BASE, user.getUsername()), new String[]{"userAccountControl"});
            Assert.assertTrue((boolean)accountStatus.toString().contains(userAccountControlValue.toString()), (String)String.format("User account value expected %s but found %s ", userAccountControlValue.toString(), accountStatus.toString()));
            return this;
        }
    }

    public static enum UserAccountControlValue {
        enabled("21037568"),
        disabled("21037570");

        private final String userAccountControlValue;

        private UserAccountControlValue(String userAccountControlValue) {
            this.userAccountControlValue = userAccountControlValue;
        }

        public String toString() {
            return this.userAccountControlValue;
        }
    }

    public static enum UserAccountStatus {
        NORMAL_ACCOUNT(512),
        PASSWD_NOTREQD(32),
        DONT_REQ_PREAUTH(0x400000),
        TRUSTED_TO_AUTH_FOR_DELEGATION(0x1000000),
        TRUSTED_FOR_DELEGATION(524288),
        DISABLE_ACCOUNT(2),
        DONT_EXPIRE_PASSWD(65536);

        private final int value;

        private UserAccountStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

