/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data;

import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.auth.DataAIS;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class DataUserAIS
extends DataUser {
    @Autowired
    DataAIS dataAIS;

    @Override
    public UserModel createUser(String userName, String password) throws DataPreparationException {
        UserModel userModel = super.createUser(userName, password);
        this.createUserInAIS(userModel);
        return userModel;
    }

    @Override
    public UserModel createUserWithCustomEmailAddressInAlfresco(String userName, String password, String domain) throws DataPreparationException {
        UserModel userModel = super.createUserWithCustomEmailAddressInAlfresco(userName, password, domain);
        this.createUserInAIS(userModel);
        return userModel;
    }

    @Override
    public UserModel createUserWithTenant(String userName) throws DataPreparationException {
        UserModel userModel = super.createUserWithTenant(userName);
        this.createUserInAIS(userModel);
        return userModel;
    }

    @Override
    public void deleteUser(UserModel userToDelete) throws DataPreparationException {
        super.deleteUser(userToDelete);
        this.deleteUserFromAIS(userToDelete);
    }

    @Override
    public void disableUser(UserModel userToDisable) {
        super.disableUser(userToDisable);
        this.disableUserInAIS(userToDisable);
    }

    private void disableUserInAIS(UserModel userModel) {
        if (this.dataAIS.isEnabled()) {
            this.dataAIS.perform().disableUser(userModel);
        }
    }

    private void deleteUserFromAIS(UserModel userModel) {
        if (this.dataAIS.isEnabled()) {
            this.dataAIS.perform().deleteUser(userModel);
        }
    }

    private void createUserInAIS(UserModel userModel) {
        if (this.dataAIS.isEnabled()) {
            this.dataAIS.perform().createUser(userModel);
        }
    }
}

