/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data;

import org.alfresco.dataprep.SiteService;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.data.TestData;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.report.log.Step;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.testng.Assert;

@Service
@Scope(value="prototype")
public class DataSite
extends TestData<DataSite> {
    @Autowired
    private SiteService siteService;
    static String SITE_NOT_CREATED = "Site %s  not created";

    public synchronized SiteModel createSite(SiteModel siteModel) throws DataPreparationException {
        Step.STEP(String.format("Creating site %s with user %s", siteModel.toString(), this.getCurrentUser().toString()));
        this.siteService.create(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), String.format(RandomStringUtils.randomAlphanumeric((int)10), EMAIL), siteModel.getId(), siteModel.getTitle(), siteModel.getDescription(), siteModel.getVisibility());
        siteModel.setGuid(this.siteService.getSiteNodeRef(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), siteModel.getId()));
        return siteModel;
    }

    public SiteModel createPublicRandomSite() throws DataPreparationException {
        String randomSite = RandomData.getRandomName("sitePublic");
        return this.createSite(new SiteModel(randomSite));
    }

    public SiteModel createModeratedRandomSite() throws DataPreparationException {
        SiteModel randomSite = new SiteModel(RandomData.getRandomName("siteModerated"), SiteService.Visibility.MODERATED);
        return this.createSite(randomSite);
    }

    public SiteModel createPrivateRandomSite() throws DataPreparationException {
        SiteModel randomSite = new SiteModel(RandomData.getRandomName("sitePrivate"), SiteService.Visibility.PRIVATE);
        return this.createSite(randomSite);
    }

    public SiteModel createIMAPSite() throws DataPreparationException {
        String imapSite = RandomData.getRandomName("IMAPsite");
        Step.STEP(String.format("Creating public site %s with user %s and setting as IMAP Favourite", imapSite, this.getCurrentUser().toString()));
        SiteModel siteModel = this.createSite(new SiteModel(imapSite));
        this.siteService.setIMAPFavorite(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), imapSite);
        return siteModel;
    }

    public void setIMAPFavorite() throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Set site %s as IMAP Favorite", this.getCurrentSite()));
        this.siteService.setIMAPFavorite(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), this.getCurrentSite());
    }

    public void unsetIMAPFavorite() throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Unset site %s as IMAP Favorite", this.getCurrentSite()));
        this.siteService.removeIMAPFavorite(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), this.getCurrentSite());
    }

    public SiteModel addSiteToFavorites() throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Add site %s to Favorites", this.getCurrentSite()));
        this.siteService.setFavorite(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), this.getCurrentSite());
        return new SiteModel(this.getCurrentSite());
    }

    public SiteModel removeSiteFromFavorites() throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Remove site %s from Favorites", this.getCurrentSite()));
        this.siteService.removeFavorite(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), this.getCurrentSite());
        return new SiteModel(this.getCurrentSite());
    }

    public boolean isSiteCreated(SiteModel siteModel) {
        return !this.siteService.getSiteNodeRef(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), siteModel.getId()).isEmpty();
    }

    public void deleteSite(SiteModel siteModel) throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Delete site %s", siteModel.getId()));
        this.siteService.delete(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), siteModel.getId());
    }

    public void updateSiteVisibility(SiteModel siteModel, SiteService.Visibility newVisibility) throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Change site %s visibility to %s", siteModel.getId(), newVisibility));
        this.siteService.updateSiteVisibility(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), siteModel.getId(), newVisibility);
    }

    public synchronized SiteModel createRMSite(SiteService.RMSiteCompliance compliance) {
        String rmSiteName = "rm";
        boolean rmCreated = this.siteService.createRMSite(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), rmSiteName, "create by TAS -> createRMSite method", compliance);
        Assert.assertTrue((boolean)rmCreated, (String)"RM Site created Successfully.");
        String rmSiteNodeRef = this.siteService.getSiteNodeRef(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), rmSiteName);
        Assert.assertNotNull((Object)rmSiteNodeRef, (String)"RM Site created Successfully. Site Node Ref captured.");
        SiteModel rmSite = new SiteModel(rmSiteName);
        rmSite.setGuid(rmSiteNodeRef);
        return rmSite;
    }
}

