/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data;

import org.alfresco.dataprep.AlfrescoHttpClient;
import org.alfresco.dataprep.AlfrescoHttpClientFactory;
import org.alfresco.dataprep.GroupService;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.data.TestData;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class DataGroup
extends TestData<DataGroup> {
    private final GroupService groupService;
    @Autowired
    private AlfrescoHttpClientFactory alfrescoHttpClientFactory;

    public DataGroup(GroupService groupService) {
        this.groupService = groupService;
    }

    public GroupModel createRandomGroup() {
        String groupName = RandomData.getRandomName("Group");
        Step.STEP(String.format("DATAPREP: Creating group %s with admin", groupName));
        GroupModel groupModel = new GroupModel(groupName);
        groupModel = this.createGroup(groupModel);
        return groupModel;
    }

    public GroupModel createGroup(GroupModel groupModel) {
        Step.STEP(String.format("DATAPREP: Creating group %s with admin", groupModel.getDisplayName()));
        this.groupService.createGroup(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), groupModel.getDisplayName());
        return groupModel;
    }

    public GroupModel addUserToGroup(GroupModel groupModel) {
        Step.STEP(String.format("DATAPREP: Add user %s to group %s", this.getCurrentUser().getUsername(), groupModel.getDisplayName()));
        this.groupService.addUserToGroup(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), groupModel.getDisplayName(), this.getCurrentUser().getUsername());
        return groupModel;
    }

    public void addGroupToParentGroup(GroupModel parentGroup, GroupModel ... groupsToAdd) {
        for (GroupModel groupModel : groupsToAdd) {
            Step.STEP(String.format("DATAPREP: Add group %s to group %s", groupModel.getDisplayName(), parentGroup.getDisplayName()));
            boolean added = this.groupService.addSubGroup(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), parentGroup.getGroupIdentifier(), groupModel.getGroupIdentifier());
            if (added) continue;
            LOG.error(String.format("Retry add group %s to group %s", groupModel.getDisplayName(), parentGroup.getDisplayName()));
            this.groupService.addSubGroup(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), parentGroup.getGroupIdentifier(), groupModel.getGroupIdentifier());
        }
    }

    public GroupModel addListOfUsersToGroup(GroupModel groupModel, UserModel ... users) {
        for (UserModel userModel : users) {
            Step.STEP(String.format("DATAPREP: Add user %s to group %s", this.getCurrentUser().getUsername(), groupModel.getDisplayName()));
            ((DataGroup)this.usingUser(userModel)).addUserToGroup(groupModel);
        }
        return groupModel;
    }

    public void deleteGroup(GroupModel groupModel) throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Deleting %s group", groupModel.getGroupIdentifier()));
        this.groupService.removeGroup(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), groupModel.getGroupIdentifier());
    }

    public void removeUserFromGroup(GroupModel groupModel, UserModel userToRemove) throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Remove user %s from group %s", userToRemove.getUsername(), groupModel.getGroupIdentifier()));
        this.groupService.removeUserFromGroup(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), groupModel.getGroupIdentifier(), userToRemove.getUsername());
    }

    public void addGroupToSite(GroupModel groupToInvite, SiteModel site, UserRole role) {
        Step.STEP(String.format("DATAPREP: Invite group '%s' to site %s with role %s", groupToInvite.getDisplayName(), site.getTitle(), role.toString()));
        this.groupService.inviteGroupToSite(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), site.getId(), groupToInvite.getGroupIdentifier(), role.toString());
    }

    public void updateGroupRole(GroupModel groupToUpdate, SiteModel site, UserRole role) {
        Step.STEP(String.format("DATAPREP: Update group role '%s' to %s in site %s", groupToUpdate.getDisplayName(), role.toString(), site.getTitle()));
        this.groupService.changeGroupRole(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), site.getId(), groupToUpdate.getGroupIdentifier(), role.toString());
    }

    public void removeGroupFromSite(GroupModel groupToRemove, SiteModel site) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        String reqUrl = String.format(client.getApiUrl() + "sites/%s/memberships/GROUP_%s", site.getId().toLowerCase(), groupToRemove.getGroupIdentifier());
        HttpDelete deleteReq = new HttpDelete(reqUrl);
        HttpResponse response = client.executeAndRelease(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), (HttpRequestBase)deleteReq);
        if (200 == response.getStatusLine().getStatusCode()) {
            LOG.info("Group {} was removed from site {}", (Object)groupToRemove.getDisplayName(), (Object)site.getId());
        } else {
            LOG.error("Failed to remove group {} from site {}. Error: {}", new Object[]{groupToRemove.getDisplayName(), site.getId(), response.toString()});
        }
    }
}

