/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.dataprep.AlfrescoHttpClient;
import org.alfresco.dataprep.AlfrescoHttpClientFactory;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.dataprep.ContentActions;
import org.alfresco.dataprep.ContentAspects;
import org.alfresco.dataprep.ContentService;
import org.alfresco.dataprep.SiteService;
import org.alfresco.dataprep.UserService;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.CustomObjectTypeProperties;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.data.TestData;
import org.alfresco.utility.data.provider.XMLAspectData;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.exception.IORuntimeException;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TagModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.testng.Assert;

@Service
@Scope(value="prototype")
public class DataContent
extends TestData<DataContent> {
    private Session session;
    private static Log logger = LogFactory.getLog(DataContent.class);
    @Autowired
    private AlfrescoHttpClientFactory alfrescoHttpClientFactory;
    @Autowired
    private ContentService contentService;
    @Autowired
    private ContentAspects contentAspect;
    @Autowired
    private ContentActions contentActions;
    @Autowired
    private SiteService siteService;
    @Autowired
    private UserService userService;
    private FileModel customModel;

    public ContentActions getContentActions() {
        return this.contentActions;
    }

    private Session getSession() {
        if (this.session == null) {
            return this.usingAdmin().session;
        }
        return this.session;
    }

    @Override
    public DataContent usingUser(UserModel user) {
        this.currentUser = user;
        this.session = this.contentService.getCMISSession(user.getUsername(), user.getPassword());
        return this;
    }

    @Override
    public DataContent usingAdmin() {
        return this.usingUser(this.getAdminUser());
    }

    public FolderModel createFolder() {
        return this.createFolder(new FolderModel(RandomData.getRandomName("Folder")));
    }

    public FolderModel createFolder(FolderModel folderModel) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        return this.createFolder(folderModel, client.getAlfVersion() >= 5.2);
    }

    public FolderModel createFolder(FolderModel folderModel, boolean useV1API) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        if (useV1API) {
            return this.createFolderV1Api(client, folderModel, this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword());
        }
        return this.createFolderCmisApi(folderModel.getName());
    }

    public FolderModel createFolderV1Api(AlfrescoHttpClient client, FolderModel folderModel, String username, String password) {
        Step.STEP(String.format("DATAPREP: Create folder '%s' in %s", folderModel.getName(), this.getCurrentSpace()));
        String nodeId = this.getLastNodeId();
        String reqUrl = client.getApiVersionUrl() + "nodes/" + nodeId + "/children";
        HttpPost post = new HttpPost(reqUrl);
        JSONObject body = new JSONObject();
        body.put((Object)"name", (Object)folderModel.getName());
        body.put((Object)"nodeType", (Object)"cm:folder");
        JSONObject properties = new JSONObject();
        if (folderModel.getTitle() != null) {
            properties.put((Object)"cm:title", (Object)folderModel.getTitle());
        }
        if (folderModel.getDescription() != null) {
            properties.put((Object)"cm:description", (Object)folderModel.getDescription());
        }
        body.put((Object)"properties", (Object)properties);
        post.setEntity((HttpEntity)client.setMessageBody(body));
        logger.info((Object)String.format("POST: '%s'", reqUrl));
        HttpResponse response = client.execute(username, password, (HttpRequestBase)post);
        if (201 == response.getStatusLine().getStatusCode()) {
            JSONObject entryResponse = client.readStream(response.getEntity());
            JSONObject entryValueMap = (JSONObject)entryResponse.get((Object)"entry");
            folderModel.setNodeRef(entryValueMap.get((Object)"id").toString());
            folderModel.setName(entryValueMap.get((Object)"name").toString());
            String folderLocation = Utility.buildPath(this.getLastResource(), folderModel.getName());
            folderModel.setCmisLocation(folderLocation);
            folderModel.setProtocolLocation(folderLocation);
            logger.info((Object)String.format("Successful created folder with id '%s' ", entryValueMap.get((Object)"id").toString()));
            return folderModel;
        }
        throw new RuntimeException("Could not create folder. Request response: " + client.getParameterFromJSON(response, "briefSummary", new String[]{"error"}));
    }

    public FolderModel createFolderCmisApi(String folderName) {
        Step.STEP(String.format("DATAPREP: Create folder '%s' in %s", folderName, this.getCurrentSpace()));
        FolderModel folderModel = new FolderModel(folderName);
        String location = Utility.buildPath(this.getCurrentSpace(), folderName);
        this.setLastResource(location);
        Folder cmisFolder = this.contentService.createFolderInRepository(this.getSession(), folderName, this.getCurrentSpace());
        folderModel.setProtocolLocation(cmisFolder.getPath());
        folderModel.setCmisLocation(cmisFolder.getPath());
        folderModel.setNodeRef(cmisFolder.getId());
        return folderModel;
    }

    public void deleteContent() {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        if (client.getAlfVersion() >= 5.2) {
            this.deleteContentV1RestApi(client);
        } else {
            this.deleteContentCmisApi();
        }
    }

    public void deleteContentV1RestApi(AlfrescoHttpClient client) {
        Step.STEP(String.format("DATAPREP: Deleting '%s' with id '%s'", this.getLastResource(), this.getLastNodeId()));
        String nodeId = this.getLastNodeId();
        String reqUrl = client.getApiVersionUrl() + "nodes/" + nodeId;
        HttpDelete delete = new HttpDelete(reqUrl);
        logger.info((Object)String.format("DELETE: '%s'", reqUrl));
        HttpResponse response = client.execute(this.currentUser.getUsername(), this.currentUser.getPassword(), (HttpRequestBase)delete);
        if (204 != response.getStatusLine().getStatusCode()) {
            throw new RuntimeException("Could not delete file. Request response: " + client.getParameterFromJSON(response, "briefSummary", new String[]{"error"}));
        }
        logger.info((Object)String.format("Successful deleted content with id '%s' ", nodeId));
    }

    public void deleteContentCmisApi() {
        Step.STEP(String.format("DATAPREP: Deleting '%s'", this.getLastResource()));
        this.contentService.deleteContentByPath(this.getSession(), this.getLastResource());
    }

    public void renameContent(ContentModel newContent) {
        File file = new File(this.getLastResource());
        Step.STEP(String.format("DATAPREP: Rename content '%s' in %s", file.getName(), this.getCurrentSpace()));
        this.contentActions.renameContent(this.getSession(), this.getLastResource(), newContent.getName());
    }

    public String addEmailAlias(String alias) {
        String folderName = new File(this.getLastResource()).getName();
        Utility.checkObjectIsInitialized(folderName, "getLastResource()");
        Step.STEP(String.format("DATAPREP: Add 'Email Alias' aspect to folder '%s'", folderName));
        this.contentAspect.addEmailAlias(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), this.getCurrentSite(), folderName, alias);
        return alias;
    }

    public FileModel createContent() {
        return this.createContent(new FileModel(RandomData.getRandomName("File")));
    }

    public FileModel createContent(FileModel fileModel) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        if (client.getAlfVersion() >= 5.2) {
            FileModel createFile = this.createContentV1Api(client, fileModel);
            this.updateContent(client, createFile);
            return createFile;
        }
        return this.createContentCmisApi(fileModel);
    }

    public FileModel createContentV1Api(AlfrescoHttpClient client, FileModel fileModel) {
        Step.STEP(String.format("DATAPREP: Create file '%s' in %s", fileModel.getName(), this.getCurrentSpace()));
        String nodeId = this.getLastNodeId();
        String reqUrl = client.getApiVersionUrl() + "nodes/" + nodeId + "/children";
        HttpPost post = new HttpPost(reqUrl);
        JSONObject body = new JSONObject();
        body.put((Object)"name", (Object)fileModel.getName());
        body.put((Object)"nodeType", (Object)"cm:content");
        JSONObject properties = new JSONObject();
        if (fileModel.getTitle() != null) {
            properties.put((Object)"cm:title", (Object)fileModel.getTitle());
        }
        if (fileModel.getDescription() != null) {
            properties.put((Object)"cm:description", (Object)fileModel.getDescription());
        }
        body.put((Object)"properties", (Object)properties);
        post.setEntity((HttpEntity)client.setMessageBody(body));
        logger.info((Object)String.format("POST: '%s'", reqUrl));
        HttpResponse response = client.execute(this.currentUser.getUsername(), this.currentUser.getPassword(), (HttpRequestBase)post);
        if (201 == response.getStatusLine().getStatusCode()) {
            JSONObject entryResponse = client.readStream(response.getEntity());
            JSONObject entryValueMap = (JSONObject)entryResponse.get((Object)"entry");
            fileModel.setNodeRef(entryValueMap.get((Object)"id").toString());
            fileModel.setName(entryValueMap.get((Object)"name").toString());
            String fileLocation = Utility.buildPath(this.getLastResource(), fileModel.getName());
            fileModel.setCmisLocation(fileLocation);
            fileModel.setProtocolLocation(fileLocation);
            if (fileModel.getContent().isEmpty()) {
                fileModel.setContent("This is a test file");
            }
            logger.info((Object)String.format("Successful created content with id '%s' ", entryValueMap.get((Object)"id").toString()));
            return fileModel;
        }
        throw new RuntimeException("Could not create file. Request response: " + client.getParameterFromJSON(response, "briefSummary", new String[]{"error"}));
    }

    public void updateContent(AlfrescoHttpClient client, FileModel fileModel) {
        CMISUtil.DocumentType documentType = fileModel.getFileType().getDocumentType();
        this.updateContent(client, fileModel, documentType);
    }

    public FileModel createContentCmisApi(FileModel fileModel) throws DataPreparationException {
        String fileFullName = fileModel.getName();
        if (FilenameUtils.getExtension((String)fileFullName).length() == 0) {
            fileFullName = String.format("%s.%s", fileModel.getName(), fileModel.getFileType().extension);
        }
        Step.STEP(String.format("DATAPREP: Creating a new non-empty content %s in %s ", fileModel.getName(), this.getLastResource()));
        if (this.getLastResource().isEmpty()) {
            this.setLastResource(RandomData.getRandomName("Folder"));
        }
        Document cmisDocument = null;
        try {
            cmisDocument = this.contentService.createDocumentInRepository(this.getSession(), this.getLastResource(), CMISUtil.DocumentType.valueOf((String)fileModel.getFileType().toString()), fileFullName, fileModel.getContent());
            if (fileModel.getTitle() != null || fileModel.getDescription() != null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("cm:title", fileModel.getTitle());
                properties.put("cm:description", fileModel.getDescription());
                cmisDocument.updateProperties(properties);
            }
        }
        catch (CmisStorageException cse) {
            cmisDocument = this.contentService.createDocumentInRepository(this.getSession(), this.getLastResource(), CMISUtil.DocumentType.valueOf((String)fileModel.getFileType().toString()), fileFullName, fileModel.getContent());
        }
        String fileLocation = Utility.buildPath(this.getLastResource(), fileFullName);
        fileModel.setCmisLocation(fileLocation);
        fileModel.setProtocolLocation(fileLocation);
        fileModel.setNodeRef(cmisDocument.getId());
        return fileModel;
    }

    public FileModel createContent(CMISUtil.DocumentType documentType) throws DataPreparationException {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        if (client.getAlfVersion() >= 5.2) {
            String fileName = RandomData.getRandomName("file");
            FileModel fileModel = new FileModel(fileName, FileType.fromName(fileName + "." + documentType.extention));
            FileModel createFile = this.createContentDocTypeV1Api(client, fileModel, documentType);
            this.updateContent(client, createFile, documentType);
            return createFile;
        }
        return this.createContentDocTypeCmisApi(documentType);
    }

    public FileModel createContentDocTypeV1Api(AlfrescoHttpClient client, FileModel fileModel, CMISUtil.DocumentType documentType) {
        fileModel.setName(String.format("%s.%s", fileModel.getName(), Utility.cmisDocTypeToExtentions(documentType)));
        return this.createContentV1Api(client, fileModel);
    }

    public void updateContent(AlfrescoHttpClient client, FileModel fileModel, CMISUtil.DocumentType documentType) {
        String nodeId = fileModel.getNodeRef();
        String reqUrl = client.getApiVersionUrl() + "nodes/" + nodeId + "/content?majorVersion=true";
        HttpPut put = new HttpPut(reqUrl);
        String fileContent = fileModel.getContent();
        if (documentType != null) {
            String contentType = documentType.type + ";charset=" + "UTF-8";
            put.addHeader("Content-Type", contentType);
        }
        StringEntity se = new StringEntity(fileContent, "UTF-8");
        se.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
        put.setEntity((HttpEntity)se);
        logger.info((Object)String.format("Update content for file with name '%s' by POST: '%s'", fileModel.getName(), reqUrl));
        HttpResponse response = client.executeAndRelease(this.currentUser.getUsername(), this.currentUser.getPassword(), (HttpRequestBase)put);
        if (200 != response.getStatusLine().getStatusCode()) {
            throw new RuntimeException("Could not update file. Request response: " + client.getParameterFromJSON(response, "briefSummary", new String[]{"error"}));
        }
        logger.info((Object)String.format("Successfully updated content", new Object[0]));
    }

    public FileModel createContentDocTypeCmisApi(CMISUtil.DocumentType documentType) throws DataPreparationException {
        String newContent = String.format("%s.%s", RandomData.getRandomName("file"), Utility.cmisDocTypeToExtentions(documentType));
        String newLocation = Utility.buildPath(this.getLastResource(), newContent);
        Step.STEP(String.format("DATAPREP: Creating a new non-empty content %s in %s ", newContent, this.getLastResource()));
        if (this.getLastResource().isEmpty()) {
            this.setLastResource(RandomData.getRandomName("Folder"));
        }
        Document cmisDocument = null;
        try {
            cmisDocument = this.contentService.createDocumentInRepository(this.getSession(), this.getLastResource(), documentType, newContent, "This is a file file");
        }
        catch (CmisStorageException cse) {
            cmisDocument = this.contentService.createDocumentInRepository(this.getSession(), this.getLastResource(), documentType, newContent, "This is a file file");
        }
        FileModel newFile = new FileModel(cmisDocument.getName());
        newFile.setCmisLocation(newLocation);
        newFile.setProtocolLocation(newLocation);
        newFile.setNodeRef(cmisDocument.getId());
        return newFile;
    }

    public void assertContentExist() throws TestConfigurationException {
        Step.STEP(String.format("DATAPREP: Check that content %s exists.", this.getLastResource()));
        boolean contentExist = this.checkContent(this.getLastResource(), this.getCurrentUser());
        Assert.assertTrue((boolean)contentExist, (String)String.format("Content {%s} was found in repository", this.getLastResource()));
    }

    public void assertContentDoesNotExist() throws TestConfigurationException {
        Step.STEP(String.format("DATAPREP: Check that content does not %s exist.", this.getLastResource()));
        boolean contentDoesNotExist = this.checkContent(this.getLastResource(), this.getCurrentUser());
        Assert.assertFalse((boolean)contentDoesNotExist, (String)String.format("Content {%s} was NOT found in repository", this.getLastResource()));
    }

    public boolean checkContent(String fullPath, UserModel userModel) throws TestConfigurationException {
        if (fullPath == null || fullPath.isEmpty()) {
            throw new TestConfigurationException("You didn't specify your #lastResource. Please call #usingResource(..) or #setLastResource(...) methods");
        }
        return !this.contentService.getNodeRefByPath(this.getSession(), Utility.convertBackslashToSlash(fullPath)).isEmpty();
    }

    public void waitUntilContentIsDeleted(String fullPath) {
        String deletedObject = this.contentService.getNodeRefByPath(this.getSession(), fullPath);
        for (int retry = 0; !StringUtils.isEmpty((CharSequence)deletedObject) && retry < Utility.retryCountSeconds; ++retry) {
            Utility.waitToLoopTime(1, new String[0]);
            deletedObject = this.contentService.getNodeRefByPath(this.getSession(), fullPath);
        }
    }

    public void waitUntilContentIsCreated(String fullPath) {
        LOG.info("Wait until new content is created up to 15 seconds");
        String newObject = this.contentService.getNodeRefByPath(this.getSession(), fullPath);
        for (int retry = 0; StringUtils.isEmpty((CharSequence)newObject) && retry < 15; ++retry) {
            Utility.waitToLoopTime(1, new String[0]);
            newObject = this.contentService.getNodeRefByPath(this.getSession(), fullPath);
        }
    }

    public void waitUntilContentIsCreatedInLinux(String fullPath) {
        if (SystemUtils.IS_OS_LINUX) {
            this.waitUntilContentIsCreated(fullPath);
        }
    }

    public void deleteSite(SiteModel site) {
        if (this.siteService.exists(site.getId(), this.getAdminUser().getUsername(), this.getAdminUser().getPassword())) {
            LOG.info("Deleting site {} with user {}", (Object)site.toString(), (Object)this.getCurrentUser().toString());
            this.siteService.delete(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), this.getCurrentUser().getDomain(), site.getId());
        }
    }

    public void deleteTree(FolderModel from) {
        LOG.info("Deleting entire tree of {}", (Object)from.getCmisLocation());
        this.contentService.deleteTreeByPath(this.getSession(), from.getCmisLocation());
    }

    public void setCustomModel(String localModelXMLFilePath) {
        CmisObject modelInRepo;
        File file = Utility.getTestResourceFile(localModelXMLFilePath);
        LOG.info("Deploying custom content Model from XML file: {}", (Object)file.getPath());
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException ef) {
            throw new TestConfigurationException("Could not find your custom model XML file provided:" + ef.getMessage());
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("cmis:objectTypeId", "D:cm:dictionaryModel");
        props.put("cmis:name", file.getName());
        props.put("cm:modelActive", true);
        Session session = this.contentService.getCMISSession(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword());
        ContentStream contentStream = session.getObjectFactory().createContentStream(file.getName(), file.length(), FilenameUtils.getExtension((String)file.getPath()), (InputStream)inputStream);
        try {
            modelInRepo = session.getObjectByPath(String.format("/Data Dictionary/Models/%s", file.getName()));
            if (modelInRepo != null) {
                LOG.info("Custom Content Model [{}] is already deployed under [/Data Dictionary/Models/] location", (Object)localModelXMLFilePath);
            }
        }
        catch (Exception e) {
            Folder model = (Folder)session.getObjectByPath("/Data Dictionary/Models");
            modelInRepo = model.createDocument(props, contentStream, VersioningState.MAJOR);
            LOG.info("Custom Content Model [{}] is now deployed under [/Data Dictionary/Models/] location", (Object)localModelXMLFilePath);
        }
        this.customModel = new FileModel(modelInRepo.getName());
        this.customModel.setNodeRef(modelInRepo.getId());
        this.customModel.setNodeRef(this.customModel.getNodeRefWithoutVersion());
        this.customModel.setCmisLocation(String.format("/Data Dictionary/Models/%s", file.getName()));
        LOG.info("Custom Model file: " + this.customModel.getCmisLocation());
    }

    public void deployContentModel(String localModelXMLFilePath) throws TestConfigurationException {
        this.setCustomModel(localModelXMLFilePath);
    }

    public FileModel getCustomModel() {
        return this.customModel;
    }

    public ContentStream getContentStream(String fileName, String content) {
        ContentStreamImpl contentStream;
        if (content == null) {
            content = "";
        }
        try {
            byte[] byteContent = content.getBytes("UTF-8");
            ByteArrayInputStream stream = new ByteArrayInputStream(byteContent);
            DataInputStream dataInputStream = new DataInputStream(stream);
            byteContent = new byte[content.length()];
            dataInputStream.readFully(byteContent);
            ByteArrayInputStream bInput = new ByteArrayInputStream(byteContent);
            contentStream = new ContentStreamImpl(fileName, BigInteger.valueOf(byteContent.length), FileType.fromName((String)fileName).mimeType, (InputStream)bInput);
            bInput.close();
            dataInputStream.close();
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return contentStream;
    }

    public void closeContentStream(ContentStream contentStream) {
        try {
            contentStream.getStream().close();
        }
        catch (IOException e) {
            LOG.error("Unable to close the content stream", (Throwable)e);
        }
    }

    public ContentModel createCustomContent(ContentModel contentModel, String objectTypeID, CustomObjectTypeProperties objectTypeProperty) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", objectTypeID);
        properties.put("cmis:name", contentModel.getName());
        ArrayList<String> aspects = new ArrayList<String>();
        aspects.add("P:cm:titled");
        properties.put("cmis:secondaryObjectTypeIds", aspects);
        properties.put("cm:title", contentModel.getTitle());
        properties.put("cm:description", contentModel.getDescription());
        File fullPath = new File(String.format("%s/%s", this.getCurrentSpace(), contentModel.getName()));
        String parentFolder = Utility.convertBackslashToSlash(fullPath.getParent());
        LOG.info("Creating custom Content Model {} in: {}", (Object)contentModel.toString(), (Object)fullPath.getPath());
        CmisObject parentCMISFolder = this.contentService.getCmisObject(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), parentFolder);
        if (parentCMISFolder instanceof Document) {
            throw new TestConfigurationException(String.format("It seems the parent folder of your resource %s is a file", fullPath));
        }
        Folder folder = (Folder)parentCMISFolder;
        if (contentModel instanceof FolderModel) {
            Step.STEP(String.format("DATAPREP: Create custom Folder '%s' with typeID: %s, in '%s'", contentModel.getName(), objectTypeID, this.getCurrentSpace()));
            Folder newFolder = folder.createFolder(properties);
            if (objectTypeProperty != null) {
                objectTypeProperty.applyPropertiesTo((CmisObject)newFolder);
            }
            contentModel.setNodeRef(newFolder.getId());
        }
        if (contentModel instanceof FileModel) {
            FileModel fileModel = (FileModel)contentModel;
            Step.STEP(String.format("DATAPREP: Create custom File '%s' with typeID: %s, in '%s'", contentModel.getName(), objectTypeID, this.getCurrentSpace()));
            ContentStream contentStream = this.getContentStream(contentModel.getName(), fileModel.getContent());
            Document newFile = folder.createDocument(properties, contentStream, VersioningState.MAJOR);
            if (objectTypeProperty != null) {
                objectTypeProperty.applyPropertiesTo((CmisObject)newFile);
            }
            contentModel.setNodeRef(newFile.getId());
            this.closeContentStream(contentStream);
        }
        contentModel.setProtocolLocation(fullPath.getPath());
        contentModel.setCmisLocation(fullPath.getPath());
        return contentModel;
    }

    public void addTagToContent(TagModel model) throws TestConfigurationException {
        Step.STEP(String.format("DATAPREP: Create '%s' tag ", model.getTag()));
        if (this.getLastResource() == null || this.getLastResource().isEmpty()) {
            throw new TestConfigurationException("You didn't specify your last resource in your tests. Please call usingResource(...) before adding a tag");
        }
        this.contentActions.addSingleTag(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), this.getLastResource(), model.getTag());
    }

    public void assertContentHasTag(String cmisObjectPath, TagModel model) {
        Step.STEP(String.format("DATAPREP: Verify content %s has tag %s", cmisObjectPath, model.getTag()));
        List tags = this.contentActions.getTagNamesFromContent(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), cmisObjectPath);
        boolean found = false;
        for (String tag : tags) {
            if (model == null || model.getTag() == null || !tag.equals(model.getTag().toLowerCase())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found, (String)"content has tag");
    }

    public String getNodeRef() {
        return this.contentService.getNodeRefByPath(this.getSession(), Utility.convertBackslashToSlash(this.getLastResource()));
    }

    public Document getCMISDocument(String filePath) {
        return this.contentService.getDocumentObject(this.getSession(), filePath);
    }

    public Folder getCMISFolder(String folderPath) {
        return this.contentService.getFolderObject(this.getSession(), folderPath);
    }

    public void addAspect(List<XMLAspectData> aspects) {
        ArrayList<String> allAspectNames = new ArrayList<String>();
        for (XMLAspectData aspect : aspects) {
            allAspectNames.add(aspect.getName());
        }
        this.contentAspect.addAspect(this.getSession(), this.getLastResource(), allAspectNames.toArray(new String[0]));
        for (XMLAspectData aspect : aspects) {
            if (!aspect.hasProperties()) continue;
            LOG.info("Preparing to apply {}", (Object)aspect.toString());
            this.contentActions.addProperties(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), this.getLastResource(), aspect.getPropertiesAsHashMap());
        }
    }

    public void addFileToFavorites(FileModel file) throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Add file %s.%s to Favorites", file.getName(), file.getFileType().extension));
        this.contentActions.setFileAsFavorite(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), this.getCurrentSite(), String.format("%s.%s", file.getName(), file.getFileType().extension));
    }

    public void addFolderToFavorites(FolderModel folder) throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Add folder %s to Favorites", folder.getName()));
        this.contentActions.setFolderAsFavorite(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), this.getCurrentSite(), folder.getName());
    }

    public void assertContentVersionIs(String version) {
        Step.STEP(String.format("DATAPREP: Asserting that the version of the '%s' content is %s", this.getLastResource(), version));
        String currentVersion = this.getCMISDocument(this.getLastResource()).getVersionLabel();
        Assert.assertEquals((String)currentVersion, (String)version);
    }

    public void assertContentSizeIs(long sizeInBytes) {
        Step.STEP(String.format("DATAPREP: Asserting that the size of the '%s' content is %s", this.getLastResource(), sizeInBytes));
        Document lastVersionDocument = this.getCMISDocument(this.getLastResource());
        lastVersionDocument.refresh();
        Assert.assertEquals((long)lastVersionDocument.getContentStreamLength(), (long)sizeInBytes, (String)"The size of the content is not as expected.");
    }

    public void checkOutDocument() {
        Step.STEP(String.format("DATAPREP: Check out document %s", this.getLastResource()));
        this.contentActions.checkOut(this.getSession(), this.getLastResource());
    }

    public void cancelCheckOut() {
        Step.STEP(String.format("DATAPREP: Cancel check out on document %s", this.getLastResource()));
        this.contentActions.cancelCheckOut(this.getSession(), this.getLastResource());
    }

    public void updateContent(String newContent) {
        String path = this.getLastResource();
        Step.STEP(String.format("DATAPREP: Update content for document from %s", path));
        this.contentService.updateDocumentContent(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), path, newContent);
    }

    public void checkIn(String newContent, boolean majorVersion, String checkInComment) {
        String docName = new File(this.getLastResource()).getName();
        Step.STEP(String.format("DATAPREP: Check in document %s", docName));
        this.contentActions.checkIn(this.getSession(), this.getLastResource(), newContent, majorVersion, checkInComment);
    }

    public void setInheritPermissions(boolean inheritPermissions) {
        String contentPath = this.getLastResource();
        Step.STEP(String.format("DATAPREP: Set inherit permissions to %s for %s", inheritPermissions, contentPath));
        this.contentActions.setInheritPermissions(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), contentPath, inheritPermissions);
    }

    public void emptyUserTrashcan(UserModel user) {
        this.userService.emptyTrashcan(user.getUsername(), user.getPassword());
    }

    public FileModel uploadDocument(File fileToUpload) {
        this.contentService.uploadFileInRepository(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), Utility.removeLastSlash(this.getLastResource()), fileToUpload.getAbsolutePath());
        FileModel alfrescoFile = new FileModel(fileToUpload.getName());
        alfrescoFile.setCmisLocation(Utility.buildPath(this.getLastResource(), fileToUpload.getName()));
        return alfrescoFile;
    }
}

