/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.report.json;

import org.alfresco.utility.LogFactory;
import org.alfresco.utility.Utility;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.report.json.JsonSuite;
import org.slf4j.Logger;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class JsonReportListener
implements ITestListener {
    protected Logger LOG = LogFactory.getLogger();
    JsonSuite suite;
    String jsonPathFile = null;

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult result) {
        this.suite.getTestClass().addTest(result);
    }

    public void onTestFailure(ITestResult result) {
        this.suite.getTestClass().addTest(result);
    }

    public void onTestSkipped(ITestResult result) {
        this.suite.getTestClass().addTest(result);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.suite.getTestClass().addTest(result);
    }

    public void onStart(ITestContext context) {
        if (this.jsonPathFile == null) {
            try {
                this.jsonPathFile = Utility.getProperties(this.getClass(), Utility.getEnvironmentPropertyFile()).getProperty("reports.path");
            }
            catch (TestConfigurationException e) {
                this.LOG.error("CANNOT Read environment properties file for reports.path: {} ", (Object)e.getMessage());
            }
        }
        this.suite = new JsonSuite(context, this.jsonPathFile);
    }

    public void onFinish(ITestContext context) {
        try {
            this.suite.setFinishedAt(context.getEndDate().toString());
            this.suite.writeToDisk();
        }
        catch (Exception e) {
            this.LOG.error("CANNOT GENERATE JSON Test File: {} ", (Object)e.getMessage());
        }
    }
}

