/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.network;

import java.io.IOException;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.network.HttpConsoleOperation;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.stereotype.Service;

@Service
public class TenantConsole
extends HttpConsoleOperation {
    public TenantConsole() {
        super("/alfresco/s/admin/admin-tenantconsole");
    }

    public boolean tenantExist() throws IOException {
        return this.execute(new BasicNameValuePair("tenant-cmd", "show tenants")).toString().contains("tenant");
    }

    public boolean tenantExist(String scheme, String server, int port, String adminUserName, String adminPassword) throws Exception {
        this.properties = new TasProperties();
        this.properties.setScheme(scheme);
        this.properties.setServer(server);
        this.properties.setPort(port);
        this.properties.setAdminPassword(adminUserName);
        this.properties.setAdminUserName(adminUserName);
        return this.execute(new BasicNameValuePair("tenant-cmd", "show tenants")).toString().contains("tenant");
    }

    public boolean createTenant(String tenant, String password) throws Exception {
        return this.execute(new BasicNameValuePair("tenant-cmd", String.format("create %s %s", tenant, password))).toString().contains("created");
    }

    public UserModel createRandomTenant() throws Exception {
        UserModel adminTenant = UserModel.getAdminTenantUser();
        this.createTenant(adminTenant.getDomain(), "password");
        return adminTenant;
    }
}

