/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;

@XmlType(name="folder")
public class FolderModel
extends ContentModel {
    protected List<FileModel> files = new ArrayList<FileModel>();

    public FolderModel() {
    }

    public FolderModel(String name) {
        super(name);
    }

    public FolderModel(String name, String title, String description) {
        super(name, title, description);
    }

    public FolderModel(FolderModel originalFolder) {
        this(originalFolder.getName(), originalFolder.getTitle(), originalFolder.getDescription());
        this.setCmisLocation(originalFolder.getCmisLocation());
        this.setProtocolLocation(originalFolder.getProtocolLocation());
    }

    @XmlElement(name="file")
    public List<FileModel> getFiles() {
        if (this.files == null) {
            this.files = new ArrayList<FileModel>();
        }
        return this.files;
    }

    public void setFiles(List<FileModel> files) {
        this.files = files;
    }

    public static FolderModel getRandomFolderModel() {
        FolderModel model = new FolderModel(RandomData.getRandomFolder());
        LOG.info("Generating new FolderModel: {}", (Object)model.toString());
        return model;
    }

    public FileModel lastFile() {
        return this.getFiles().get(this.getFiles().size() - 1);
    }

    public FileModel generateRandomFileChild(FileType fileType) {
        FileModel model = FileModel.getRandomFileModel(fileType);
        this.getFiles().add(model);
        return model;
    }

    public static FolderModel getSharedFolderModel() {
        return new FolderModel("/Shared");
    }

    public static FolderModel getImapAttachmentsFolderModel() {
        return new FolderModel("/Imap Attachments");
    }

    public static FolderModel getGuestHomeFolderModel() {
        return new FolderModel("/Guest Home");
    }

    public static FolderModel getUserHomesFolderModel() {
        return new FolderModel("/User Homes");
    }

    public static FolderModel getSitesFolderModel() {
        return new FolderModel("/Sites");
    }

    public static FolderModel getDataDictionaryFolderModel() {
        return new FolderModel("/Data Dictionary");
    }

    public static FolderModel getIMAPHomeFolderModel() {
        return new FolderModel("/IMAP Home");
    }
}

