/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.model;

import com.google.common.io.Files;
import java.util.stream.Stream;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.utility.data.DataValue;

public enum FileType {
    UNDEFINED("N#A", DataValue.UNDEFINED.toString()),
    EXE("N#A", "exe"),
    TEXT_PLAIN("text/plain", "txt"),
    XML("text/xml", "xml"),
    HTML("text/html", "html"),
    PDF("application/pdf", "pdf"),
    MSWORD("application/msword", "doc"),
    MSWORD2007("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx"),
    MSEXCEL("application/vnd.ms-excel", "xls"),
    MSEXCEL2007("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx"),
    MSPOWERPOINT("application/vnd.ms-powerpoint", "ppt"),
    MSPOWERPOINT2007("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx");

    public final String mimeType;
    public final String extension;

    private FileType(String mimeType, String extension) {
        this.mimeType = mimeType;
        this.extension = extension;
    }

    public static FileType fromName(String fileName) {
        String extension = Files.getFileExtension((String)fileName);
        for (FileType ft : FileType.values()) {
            if (!ft.extension.equals(extension)) continue;
            return ft;
        }
        return UNDEFINED;
    }

    public CMISUtil.DocumentType getDocumentType() {
        return Stream.of(CMISUtil.DocumentType.values()).filter(documentType -> documentType.type.equals(this.mimeType)).findFirst().orElse(Stream.of(CMISUtil.DocumentType.values()).filter(documentType -> documentType.extention.equals(this.extension)).findFirst().orElse(null));
    }
}

