/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.provider;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.provider.XMLDataConfig;
import org.alfresco.utility.data.provider.XMLSiteData;
import org.alfresco.utility.data.provider.XMLTestData;
import org.alfresco.utility.data.provider.XMLUserData;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.QueryModel;
import org.testng.annotations.DataProvider;

public class XMLTestDataProvider {
    private static XMLTestData initializeXMLFileData(Method m) throws Exception {
        XMLDataConfig config = m.getAnnotation(XMLDataConfig.class);
        if (config == null) {
            throw new DataPreparationException("Please annotate your test that is using XMLTestDataProvider with @XMLDataConfig(file='../location-to-your-xml-test-data-file.xml'");
        }
        Utility.waitToLoopTime(2, new String[0]);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLTestData.class});
        Unmarshaller um = context.createUnmarshaller();
        XMLTestData dataProvider = (XMLTestData)um.unmarshal(new File(config.file()));
        return dataProvider;
    }

    @DataProvider
    public static Iterator<Object[]> getSitesData(Method m) throws Exception {
        ArrayList<Object[]> dataToBeReturned = new ArrayList<Object[]>();
        XMLTestData dataReader = XMLTestDataProvider.initializeXMLFileData(m);
        List<XMLSiteData> sites = dataReader.getSites();
        for (XMLSiteData site : sites) {
            dataToBeReturned.add(new Object[]{site});
        }
        return dataToBeReturned.iterator();
    }

    @DataProvider
    public static Iterator<Object[]> getUsersData(Method m) throws Exception {
        ArrayList<Object[]> dataToBeReturned = new ArrayList<Object[]>();
        XMLTestData dataReader = XMLTestDataProvider.initializeXMLFileData(m);
        List<XMLUserData> users = dataReader.getUsers();
        for (XMLUserData user : users) {
            dataToBeReturned.add(new Object[]{user});
        }
        return dataToBeReturned.iterator();
    }

    @DataProvider
    public static Iterator<Object[]> getQueriesData(Method m) throws Exception {
        ArrayList<Object[]> dataToBeReturned = new ArrayList<Object[]>();
        XMLTestData dataReader = XMLTestDataProvider.initializeXMLFileData(m);
        List<QueryModel> queries = dataReader.getQueries();
        for (QueryModel query : queries) {
            dataToBeReturned.add(new Object[]{query});
        }
        return dataToBeReturned.iterator();
    }

    @DataProvider
    public static Object[][] getAllData(Method m) throws Exception {
        XMLTestData dataFromXMLFile = XMLTestDataProvider.initializeXMLFileData(m);
        return new Object[][]{{dataFromXMLFile}};
    }
}

