/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.provider;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.alfresco.utility.data.provider.XMLAspectData;
import org.alfresco.utility.data.provider.XMLCollection;
import org.alfresco.utility.data.provider.XMLCommentData;
import org.alfresco.utility.data.provider.XMLCustomModel;
import org.alfresco.utility.data.provider.XMLDataItem;
import org.alfresco.utility.data.provider.XMLTagData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;

@XmlType(name="file")
public class XMLFileData
extends XMLCollection
implements XMLDataItem {
    private String name;
    private String createdBy;
    private String content;
    private String id;
    private XMLCustomModel customModel;
    private List<XMLCommentData> comments = new ArrayList<XMLCommentData>();
    private List<XMLTagData> tags = new ArrayList<XMLTagData>();
    private List<XMLAspectData> aspects = new ArrayList<XMLAspectData>();
    private FileModel model = new FileModel();

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @XmlElement(name="content")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public FileModel getModel() {
        this.model.setName(this.getName());
        this.model.setFileType(FileType.fromName(this.getName()));
        this.model.setContent(this.getContent());
        this.model.setCmisLocation(String.format("%s/%s", this.getParent(), this.getName()));
        return this.model;
    }

    @XmlElementWrapper
    @XmlElement(name="comment")
    public List<XMLCommentData> getComments() {
        return this.comments;
    }

    public void setComments(List<XMLCommentData> comments) {
        this.comments = comments;
    }

    @XmlElement(name="custom-model")
    public XMLCustomModel getCustomModel() {
        return this.customModel;
    }

    public void setCustomModel(XMLCustomModel customModel) {
        this.customModel = customModel;
    }

    public boolean isCustomModel() {
        return this.customModel != null;
    }

    @XmlElementWrapper
    @XmlElement(name="tag")
    public List<XMLTagData> getTags() {
        return this.tags;
    }

    public void setTags(List<XMLTagData> tags) {
        this.tags = tags;
    }

    @Override
    @XmlAttribute(name="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    protected List<XMLDataItem> getImbricatedData() {
        this.entireStructure.add(this);
        this.entireStructure.addAll(this.getComments());
        this.entireStructure.addAll(this.getTags());
        return this.entireStructure;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("file[name='").append(this.getName()).append("',").append("createdBy='").append(this.getCreatedBy()).append("', id='").append(this.getId()).append("']");
        return info.toString();
    }

    @XmlElementWrapper
    @XmlElement(name="aspect")
    public List<XMLAspectData> getAspects() {
        return this.aspects;
    }

    public void setAspects(List<XMLAspectData> aspects) {
        this.aspects = aspects;
    }
}

