/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.model.RestTagModelsCollection;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CreateTagsTests
extends RestTest {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TAG = "tag";
    private static final String FIELD_COUNT = "count";
    private static final String TAG_NAME_PREFIX = "tag-name";
    private UserModel admin;
    private UserModel user;

    @BeforeClass
    public void init() {
        this.admin = this.dataUser.getAdminUser();
        this.user = this.dataUser.createRandomTestUser();
    }

    @Test(groups={"rest-api", "tags"})
    public void testCreateSingleTag() {
        Step.STEP((String)"Create single tag as admin");
        RestTagModel tagModel = CreateTagsTests.createTagModelWithName(RandomData.getRandomName((String)"99gat").toLowerCase());
        RestTagModel createdTag = this.restClient.authenticateUser(this.admin).withCoreAPI().createSingleTag(tagModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)createdTag.assertThat().field(FIELD_TAG).is((Object)tagModel.getTag())).assertThat().field(FIELD_ID).isNotEmpty();
        Step.STEP((String)"Verify that tag does exist in the system");
        RestTagModel tag = this.restClient.authenticateUser(this.admin).withCoreAPI().getTag(createdTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        tag.assertThat().isEqualTo((Object)createdTag, new String[0]);
    }

    @Test(groups={"rest-api", "tags"})
    public void testCreateMultipleTags() {
        Step.STEP((String)"Create several tags as admin");
        List tagModels = IntStream.range(0, 3).mapToObj(i -> CreateTagsTests.createTagModelWithName(RandomData.getRandomName((String)("tag-name-" + i)).toLowerCase())).collect(Collectors.toList());
        RestTagModelsCollection createdTags = this.restClient.authenticateUser(this.admin).withCoreAPI().createTags(tagModels);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        IntStream.range(0, tagModels.size()).forEach(i -> ((RestTagModel)((RestTagModel)createdTags.getEntries().get(i)).onModel().assertThat().field(FIELD_TAG).is((Object)((RestTagModel)tagModels.get(i)).getTag())).assertThat().field(FIELD_ID).isNotEmpty());
    }

    @Test(groups={"rest-api", "tags"})
    public void testCreateSingleTag_usingUppercaseName() {
        Step.STEP((String)"Create single tag as admin using uppercase name");
        RestTagModel tagModel = CreateTagsTests.createTagModelWithName(RandomData.getRandomName((String)TAG_NAME_PREFIX).toUpperCase());
        RestTagModel createdTag = this.restClient.authenticateUser(this.admin).withCoreAPI().createSingleTag(tagModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)createdTag.assertThat().field(FIELD_TAG).is((Object)tagModel.getTag().toLowerCase())).assertThat().field(FIELD_ID).isNotEmpty();
    }

    @Test(groups={"rest-api", "tags"})
    public void testCreateMultipleTags_withRepeatedName() {
        Step.STEP((String)"Create models of tags");
        String repeatedTagName = RandomData.getRandomName((String)TAG_NAME_PREFIX).toLowerCase();
        List<RestTagModel> tagModels = List.of(CreateTagsTests.createTagModelWithName(repeatedTagName), CreateTagsTests.createTagModelWithName(RandomData.getRandomName((String)TAG_NAME_PREFIX).toLowerCase()), CreateTagsTests.createTagModelWithName(repeatedTagName));
        Step.STEP((String)"Create several tags skipping repeating names");
        RestTagModelsCollection createdTags = this.restClient.authenticateUser(this.admin).withCoreAPI().createTags(tagModels);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        createdTags.assertThat().entriesListCountIs(2);
        ((RestModels)createdTags.assertThat().entriesListContains(FIELD_TAG, tagModels.get(0).getTag())).and().entriesListContains(FIELD_TAG, tagModels.get(1).getTag());
    }

    @Test(groups={"rest-api", "tags"})
    public void testCreateTag_asUser() {
        Step.STEP((String)"Try to create single tag as a common user and expect 403");
        RestTagModel tagModel = CreateTagsTests.createTagModelWithRandomName();
        this.restClient.authenticateUser(this.user).withCoreAPI().createSingleTag(tagModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "tags"})
    public void testCreateTags_passingEmptyList() {
        Step.STEP((String)"Pass empty list while creating tags and expect 400");
        this.restClient.authenticateUser(this.admin).withCoreAPI().createTags(Collections.emptyList());
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api", "tags"})
    public void testCreateTag_usingAlreadyExistingTagName() {
        Step.STEP((String)"Create some tag in the system");
        RestTagModel tagToCreate = CreateTagsTests.createTagModelWithRandomName();
        RestTagModel alreadyExistingTag = this.prepareOrphanTag(tagToCreate);
        alreadyExistingTag.setTag(tagToCreate.getTag());
        Step.STEP((String)"Try to use already existing tag to create duplicate and expect 409");
        this.restClient.authenticateUser(this.admin).withCoreAPI().createSingleTag(alreadyExistingTag);
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT).assertLastError().containsSummary("Duplicate child name not allowed: " + alreadyExistingTag.getTag().toLowerCase());
    }

    @Test(groups={"rest-api", "tags"})
    public void testCreateTag_includingCount() {
        Step.STEP((String)"Create single tag as admin including count and verify if it is 0");
        RestTagModel tagModel = CreateTagsTests.createTagModelWithName(RandomData.getRandomName((String)TAG_NAME_PREFIX).toLowerCase());
        RestTagModel createdTag = ((RestCoreAPI)this.restClient.authenticateUser(this.admin).withCoreAPI().include(new String[]{FIELD_COUNT})).createSingleTag(tagModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)((RestTagModel)createdTag.assertThat().field(FIELD_TAG).is((Object)tagModel.getTag())).assertThat().field(FIELD_ID).isNotEmpty()).assertThat().field(FIELD_COUNT).is((Object)0);
    }

    private RestTagModel prepareOrphanTagWithRandomName() {
        return this.prepareOrphanTag(CreateTagsTests.createTagModelWithRandomName());
    }

    private RestTagModel prepareOrphanTag(RestTagModel tagModel) {
        RestTagModel tag = this.restClient.authenticateUser(this.admin).withCoreAPI().createSingleTag(tagModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        return tag;
    }

    private static RestTagModel createTagModelWithRandomName() {
        return CreateTagsTests.createTagModelWithName(RandomData.getRandomName((String)TAG_NAME_PREFIX));
    }

    private static RestTagModel createTagModelWithName(String tagName) {
        return RestTagModel.builder().tag(tagName).create();
    }
}

