/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.candidates;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestCandidateModel;
import org.alfresco.rest.model.RestCandidateModelsCollection;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.requests.workflowAPI.RestWorkflowAPI;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataGroup;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetTaskCandidatesRegressionTests
extends RestTest {
    private UserModel userModel;
    private UserModel userModel1;
    private UserModel userModel2;
    private SiteModel siteModel;
    private FileModel fileModel;
    private TaskModel taskModel;
    private GroupModel group;
    private RestCandidateModelsCollection candidateModels;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.userModel1 = this.dataUser.createRandomTestUser();
        this.userModel2 = this.dataUser.createRandomTestUser();
        this.group = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(this.group, new UserModel[]{this.userModel1, this.userModel2});
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify get task candidates with invalid task id")
    public void getTaskCandidatesWithInvalidTaskId() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
        this.taskModel.setId("invalid-id");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalid-id")).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify get task candidates with empty task id")
    public void getTaskCandidatesWithEmptyTaskId() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
        this.taskModel.setId("");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify get task candidates for completed task")
    public void getTaskCandidatesForCompletedTask() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
        this.restClient.authenticateUser(this.userModel1).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((DataWorkflow)this.dataWorkflow.usingUser(this.userModel1)).taskDone(this.taskModel);
        this.restClient.authenticateUser(this.userModel1).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.taskModel.getId()));
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.taskModel.getId()));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify get task candidates by non candidate user")
    public void getTaskCandidatesByNonCandidateUser() throws Exception {
        UserModel outsider = this.dataUser.createRandomTestUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
        this.restClient.authenticateUser(outsider).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Bug(id="MNT-17438")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Get task candidates with skip count parameter")
    public void getTaskCandidatesWithSkipCount() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
        this.candidateModels = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingParams(new String[]{"skipCount=1"})).usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.candidateModels.assertThat().entriesListIsNotEmpty()).and().paginationField("count").is("0");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Get task candidates with max items parameter set to 0")
    public void getTaskCandidatesWithZeroMaxItems() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
        this.candidateModels = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingParams(new String[]{"maxItems=0"})).usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Get task candidates with max items parameter")
    public void getTaskCandidatesWithMaxItems() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
        this.candidateModels = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingParams(new String[]{"maxItems=2"})).usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.candidateModels.assertThat().entriesListIsNotEmpty()).and().paginationField("count").is("1");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Get task candidates with properties")
    public void getTaskCandidatesWithProperties() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
        this.candidateModels = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingParams(new String[]{"properties=candidateId"})).usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestCandidateModel)((RestCandidateModel)this.candidateModels.getEntries().get(0)).onModel().assertThat().field("candidateId").contains(this.group.getGroupIdentifier())).and().field("candidateType").isNull();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Get task candidates with invalid properties")
    public void getTaskCandidatesWithInvalidProperties() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
        this.candidateModels = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingParams(new String[]{"properties=unknown-prop"})).usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestCandidateModel)((RestCandidateModel)this.candidateModels.getEntries().get(0)).onModel().assertThat().fieldsCount().is((Object)0)).and();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Get task candidates by deleted candidate")
    public void getTaskCandidatesByDeletedCandidate() throws Exception {
        UserModel newUser = this.dataUser.createRandomTestUser();
        this.dataGroup.addListOfUsersToGroup(this.group, new UserModel[]{newUser});
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
        this.restClient.authenticateUser(newUser).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((DataUser)this.dataUser.usingAdmin()).deleteUser(newUser);
        this.restClient.authenticateUser(newUser).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Get task candidates by deleted group")
    public void getTaskCandidatesByDeletedGroup() throws Exception {
        GroupModel deletedGroup = this.dataGroup.createRandomGroup();
        UserModel newUser = this.dataUser.createRandomTestUser();
        this.dataGroup.addListOfUsersToGroup(deletedGroup, new UserModel[]{this.userModel2, newUser});
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(deletedGroup);
        this.restClient.authenticateUser(newUser).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((DataGroup)this.dataGroup.usingAdmin()).deleteGroup(deletedGroup);
        this.restClient.authenticateUser(newUser).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Get task candidates by user that was removed from group")
    public void getTaskCandidatesByUserRemovedFromGroup() throws Exception {
        UserModel newUser = this.dataUser.createRandomTestUser();
        this.dataGroup.addListOfUsersToGroup(this.group, new UserModel[]{newUser});
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
        this.restClient.authenticateUser(newUser).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((DataGroup)this.dataGroup.usingAdmin()).removeUserFromGroup(this.group, newUser);
        this.restClient.authenticateUser(newUser).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

