package org.alfresco.rest.search;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'krystian' on '2023-06-12 18:46' from 'Alfresco Content Services REST API' swagger file Generated from 'Alfresco Content Services REST API' swagger file Base Path {@linkplain /alfresco/api/-default-/public/search/versions/1}
 */
public class RestRequestDefaultsModel extends TestModel implements IRestModel<RestRequestDefaultsModel>
{
    @JsonProperty(value = "entry")
    RestRequestDefaultsModel model;

    @Override
    public RestRequestDefaultsModel onModel()
    {
        return model;
    }

    /**
     * A list of query fields/properties used to expand TEXT: queries. The default is cm:content. You could include all content properties using d:content or list all individual content properties or types. As more terms are included the query size, complexity, memory impact and query time will increase.
     * 
     */

    private List<String> textAttributes;
    /**
     * The default way to combine query parts when AND or OR is not explicitly stated - includes ! - + one two three (one two three)
     * 
     */

    private String defaultFTSOperator;
    /**
     * The default way to combine query parts in field query groups when AND or OR is not explicitly stated - includes ! - + FIELD:(one two three)
     * 
     */

    private String defaultFTSFieldOperator;
    /**
     * The default name space to use if one is not provided
     */

    private String namespace;

    private String defaultFieldName;

    public List<String> getTextAttributes()
    {
        return this.textAttributes;
    }

    public void setTextAttributes(List<String> textAttributes)
    {
        this.textAttributes = textAttributes;
    }

    public String getDefaultFTSOperator()
    {
        return this.defaultFTSOperator;
    }

    public void setDefaultFTSOperator(String defaultFTSOperator)
    {
        this.defaultFTSOperator = defaultFTSOperator;
    }

    public String getDefaultFTSFieldOperator()
    {
        return this.defaultFTSFieldOperator;
    }

    public void setDefaultFTSFieldOperator(String defaultFTSFieldOperator)
    {
        this.defaultFTSFieldOperator = defaultFTSFieldOperator;
    }

    public String getNamespace()
    {
        return this.namespace;
    }

    public void setNamespace(String namespace)
    {
        this.namespace = namespace;
    }

    public String getDefaultFieldName()
    {
        return this.defaultFieldName;
    }

    public void setDefaultFieldName(String defaultFieldName)
    {
        this.defaultFieldName = defaultFieldName;
    }

    @Override
    public String toString()
    {
        return "RestRequestDefaultsModel{" + "textAttributes=" + textAttributes + ", defaultFTSOperator='" + defaultFTSOperator + '\'' + ", defaultFTSFieldOperator='"
                + defaultFTSFieldOperator + '\'' + ", namespace='" + namespace + '\'' + ", defaultFieldName='" + defaultFieldName + '\'' + '}';
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        RestRequestDefaultsModel that = (RestRequestDefaultsModel) o;
        return Objects.equals(textAttributes, that.textAttributes) && Objects.equals(defaultFTSOperator, that.defaultFTSOperator) && Objects.equals(
                defaultFTSFieldOperator, that.defaultFTSFieldOperator) && Objects.equals(namespace, that.namespace) && Objects.equals(defaultFieldName, that.defaultFieldName);
    }

    @Override
    public int hashCode()
    {
        return Objects.hash(textAttributes, defaultFTSOperator, defaultFTSFieldOperator, namespace, defaultFieldName);
    }

    public static Builder builder()
    {
        return new Builder();
    }

    public static class Builder
    {
        private List<String> textAttributes;
        private String defaultFTSOperator;
        private String defaultFTSFieldOperator;
        private String namespace;
        private String defaultFieldName;

        public Builder textAttributes(List<String> textAttributes)
        {
            this.textAttributes = textAttributes;
            return this;
        }

        public Builder defaultFTSOperator(String defaultFTSOperator)
        {
            this.defaultFTSOperator = defaultFTSOperator;
            return this;
        }

        public Builder defaultFTSFieldOperator(String defaultFTSFieldOperator)
        {
            this.defaultFTSFieldOperator = defaultFTSFieldOperator;
            return this;
        }

        public Builder namespace(String namespace)
        {
            this.namespace = namespace;
            return this;
        }

        public Builder defaultFieldName(String defaultFieldName)
        {
            this.defaultFieldName = defaultFieldName;
            return this;
        }

        public RestRequestDefaultsModel create()
        {
            RestRequestDefaultsModel defaults = new RestRequestDefaultsModel();
            defaults.setTextAttributes(this.textAttributes);
            defaults.setDefaultFTSOperator(this.defaultFTSOperator);
            defaults.setDefaultFTSFieldOperator(this.defaultFTSFieldOperator);
            defaults.setNamespace(this.namespace);
            defaults.setDefaultFieldName(this.defaultFieldName);

            return defaults;
        }
    }
}
