/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.rest.repo.resource.content.PlainFileCreator;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.repo.resource.general.MultiCreator;
import org.alfresco.rest.repo.resource.general.MultipleContentsCreator;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class SerialFilesCreator
extends MultipleContentsCreator<FileModel, MultiCreator.FilesCreator>
implements MultiCreator.FilesCreator {
    private final DataContent dataContent;
    private List<FileType> fileTypes;
    private List<String> filesContents;
    private final Map<String, FileModel> filesCache;

    public SerialFilesCreator(DataContent dataContent, Map<String, FileModel> filesCache) {
        this.dataContent = dataContent;
        this.filesCache = filesCache;
    }

    @Override
    protected MultiCreator.FilesCreator self() {
        return this;
    }

    @Override
    public MultiCreator.FilesCreator ofTypes(FileType ... fileTypes) {
        this.fileTypes = List.of(fileTypes);
        return this;
    }

    @Override
    public MultiCreator.FilesCreator withContents(List<String> filesContents) {
        this.filesContents = filesContents;
        return this;
    }

    @Override
    public MultiCreator.FilesCreator withRandomContents(int wordsCount, int wordsMaxLength) {
        return this.withContents(IntStream.of(0, this.names.size()).mapToObj(i -> IntStream.range(0, wordsCount).mapToObj(j -> RandomStringUtils.randomAlphanumeric((int)1, (int)wordsMaxLength)).collect(Collectors.joining(" "))).collect(Collectors.toList()));
    }

    @Override
    public List<FileModel> create() {
        this.verifyDataConsistency();
        return this.createRawFilesUnder(this.parent, this.names);
    }

    @Override
    protected void verifyDataConsistency() {
        super.verifyDataConsistency();
        if (CollectionUtils.isEmpty(this.fileTypes) || this.fileTypes.size() < this.names.size()) {
            throw new IllegalArgumentException("Provided file types size is different from created files amount");
        }
        if (CollectionUtils.isEmpty(this.filesContents) || this.filesContents.size() < this.names.size()) {
            throw new IllegalArgumentException("Provided file contents size is different from created files amount");
        }
    }

    @Override
    protected String generateRandomName() {
        return this.generateRandomNameWith("");
    }

    @Override
    protected String generateRandomNameWith(String prefix) {
        return super.generateRandomNameWith("file" + prefix + "_");
    }

    protected FileModel createFile(String fileName, FileType fileType, String title, String description, String fileContent, FolderModel parent, String alias) {
        return (FileModel)((Creator.FileCreator)((Creator.FileCreator)((Creator.FileCreator)((Creator.FileCreator)((Creator.FileCreator)((Creator.FileCreator)((Creator.FileCreator)new PlainFileCreator(this.dataContent, this.filesCache).withAlias(alias)).withName(fileName)).ofType(fileType).withTitle(title)).withDescription(description)).withContent(fileContent).underFolder(parent)).withinSite(this.site)).asUser(this.user)).create();
    }

    private List<FileModel> createRawFilesUnder(FolderModel parent, List<String> fileNames) {
        ArrayList<FileModel> createdFiles = new ArrayList<FileModel>();
        AtomicInteger i = new AtomicInteger(0);
        fileNames.forEach(fileName -> {
            createdFiles.add(this.createFile((String)fileName, this.getOrNull(this.fileTypes, i.get()), (String)this.getOrNull(this.titles, i.get()), (String)this.getOrNull(this.descriptions, i.get()), this.getOrNull(this.filesContents, i.get()), parent, (String)this.getOrNull(this.aliases, i.get())));
            i.getAndIncrement();
        });
        return createdFiles;
    }
}

