/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests.coreAPI;

import io.restassured.RestAssured;
import java.util.List;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.model.RestDownloadsModel;
import org.alfresco.rest.model.RestSiteModelsCollection;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.model.RestTagModelsCollection;
import org.alfresco.rest.requests.Actions;
import org.alfresco.rest.requests.Audit;
import org.alfresco.rest.requests.Categories;
import org.alfresco.rest.requests.ContentStorageInformation;
import org.alfresco.rest.requests.Downloads;
import org.alfresco.rest.requests.Groups;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.rest.requests.Networks;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.requests.People;
import org.alfresco.rest.requests.Queries;
import org.alfresco.rest.requests.SharedLinks;
import org.alfresco.rest.requests.Site;
import org.alfresco.rest.requests.Tags;
import org.alfresco.rest.requests.Trashcan;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.http.HttpMethod;

public class RestCoreAPI
extends ModelRequest<RestCoreAPI> {
    public RestCoreAPI(RestWrapper restWrapper) {
        super(restWrapper);
        RestAssured.basePath = "alfresco/api/-default-/public/alfresco/versions/1";
        restWrapper.configureRequestSpec().setBasePath(RestAssured.basePath);
    }

    public Site usingSite(String siteId) {
        return new Site(new SiteModel(siteId), this.restWrapper);
    }

    public Site usingSite(SiteModel siteModel) {
        return new Site(siteModel, this.restWrapper);
    }

    public RestSiteModelsCollection getSites() {
        return new Site(null, this.restWrapper).getSites();
    }

    public Node usingResource(RepoTestModel node) {
        return new Node(node, this.restWrapper);
    }

    public Node usingNode(RepoTestModel node) {
        return new Node(node, this.restWrapper);
    }

    public Node usingNode() {
        return new Node(this.restWrapper);
    }

    public ContentStorageInformation usingStorageInfo() {
        return new ContentStorageInformation(this.restWrapper);
    }

    public People usingUser(UserModel person) {
        return new People(person, this.restWrapper);
    }

    public People usingMe() {
        UserModel userModel = new UserModel("-me-", this.restWrapper.getTestUser().getPassword());
        userModel.setDomain(this.restWrapper.getTestUser().getDomain());
        userModel.setUserRole(this.restWrapper.getTestUser().getUserRole());
        return new People(userModel, this.restWrapper);
    }

    public People usingAuthUser() {
        return new People(this.restWrapper.getTestUser(), this.restWrapper);
    }

    public Networks usingNetworks() {
        return new Networks(this.restWrapper);
    }

    public RestTagModel createSingleTag(RestTagModel tag) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, tag.toJson(), "tags/", new String[0]);
        return this.restWrapper.processModel(RestTagModel.class, request);
    }

    public RestTagModelsCollection createTags(List<RestTagModel> tags) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, JsonBodyGenerator.arrayToJson(tags), "tags/", new String[0]);
        return this.restWrapper.processModels(RestTagModelsCollection.class, request);
    }

    public Tags usingTag(RestTagModel tag) {
        return new Tags(tag, this.restWrapper);
    }

    public RestTagModelsCollection getTags() {
        return new Tags(null, this.restWrapper).getTags();
    }

    public RestTagModel getTag(RestTagModel tag) {
        return new Tags(tag, this.restWrapper).getTag();
    }

    public Categories usingCategory(RestCategoryModel categoryModel) {
        return new Categories(this.restWrapper, categoryModel);
    }

    public Queries usingQueries() {
        return new Queries(this.restWrapper);
    }

    public Audit usingAudit() {
        return new Audit(this.restWrapper);
    }

    public Trashcan usingTrashcan() {
        return new Trashcan(this.restWrapper);
    }

    public SharedLinks usingSharedLinks() {
        return new SharedLinks(this.restWrapper);
    }

    public Groups usingGroups() {
        return new Groups(this.restWrapper);
    }

    public Actions usingActions() {
        return new Actions(this.restWrapper);
    }

    public Downloads usingDownloads() {
        return new Downloads(this.restWrapper);
    }

    public Downloads usingDownloads(RestDownloadsModel downloadsModel) {
        return new Downloads(downloadsModel, this.restWrapper);
    }
}

