/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags;

import java.util.Set;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.model.RestTagModelsCollection;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.rest.tags.TagsDataPrep;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

@Test(groups={"require-solr"})
public class GetTagsTests
extends TagsDataPrep {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TAG = "tag";
    private static final String FIELD_COUNT = "count";

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role gets tags using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void getTagsWithManagerRole() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains(FIELD_TAG, documentTagValue)).and().entriesListContains(FIELD_TAG, documentTagValue2);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets tags using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "regression"})
    public void getTagsWithCollaboratorRole() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains(FIELD_TAG, documentTagValue)).and().entriesListContains(FIELD_TAG, documentTagValue2);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets tags using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "regression"})
    public void getTagsWithContributorRole() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains(FIELD_TAG, documentTagValue)).and().entriesListContains(FIELD_TAG, documentTagValue2);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role gets tags using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "regression"})
    public void getTagsWithConsumerRole() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains(FIELD_TAG, documentTagValue)).and().entriesListContains(FIELD_TAG, documentTagValue2);
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withIncludeCount() {
        Step.STEP((String)"Get tags including count filter and ensure count is as expected for returned tags");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"include=count"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.getEntries().stream().filter(e -> e.onModel().getTag().equals(folderTagValue) || e.onModel().getTag().equals(documentTagValue)).forEach(e -> e.onModel().assertThat().field(FIELD_COUNT).is((Object)2));
        returnedCollection.getEntries().stream().filter(e -> e.onModel().getTag().equals(documentTagValue2)).forEach(e -> e.onModel().assertThat().field(FIELD_COUNT).is((Object)1));
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withOrderByCountDefaultOrderShouldBeAsc() {
        Step.STEP((String)"Get tags and order results by count. Default sort order should be ascending");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"include=count&orderBy=count"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.assertThat().entriesListIsSortedAscBy(FIELD_COUNT);
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withOrderByCountAsc() {
        Step.STEP((String)"Get tags and order results by count in ascending order");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"include=count&orderBy=count ASC"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.assertThat().entriesListIsSortedAscBy(FIELD_COUNT);
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withOrderByCountDesc() {
        Step.STEP((String)"Get tags and order results by count in descending order");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"include=count&orderBy=count DESC"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.assertThat().entriesListIsSortedDescBy(FIELD_COUNT);
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withOrderByTagDefaultOrderShouldBeAsc() {
        Step.STEP((String)"Get tags and order results by tag name. Default sort order should be ascending");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"orderBy=tag"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.assertThat().entriesListIsSortedAscBy(FIELD_TAG);
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withOrderByTagAsc() {
        Step.STEP((String)"Get tags and order results by tag name in ascending order");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"orderBy=tag ASC"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.assertThat().entriesListIsSortedAscBy(FIELD_TAG);
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withOrderByTagDesc() {
        Step.STEP((String)"Get tags and order results by tag name in descending order");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"orderBy=tag DESC"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.assertThat().entriesListIsSortedDescBy(FIELD_TAG);
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_orderByCountWithoutIncludeCount() {
        this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"orderBy=count"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Failed authentication get tags call returns status code 401 with Manager role")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void failedAuthenticationReturnsUnauthorizedStatus() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        userModel = this.dataUser.createRandomTestUser();
        userModel.setPassword("user wrong password");
        this.dataUser.addUserToSite(userModel, siteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(userModel);
        this.restClient.withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that if maxItems is invalid status code returned is 400")
    @Test(groups={"rest-api", "tags", "regression"})
    public void maxItemsInvalidValueTest() {
        this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"maxItems=abc"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "abc"));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that if skipCount is invalid status code returned is 400")
    @Test(groups={"rest-api", "tags", "regression"})
    public void skipCountInvalidValueTest() {
        this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"skipCount=abc"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "abc"));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that file tag is retrieved")
    @Test(groups={"rest-api", "tags", "regression"})
    public void fileTagIsRetrieved() {
        this.restClient.authenticateUser(adminUserModel);
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains(FIELD_TAG, documentTagValue)).and().entriesListContains(FIELD_TAG, documentTagValue2);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that folder tag is retrieved")
    @Test(groups={"rest-api", "tags", "regression"})
    public void folderTagIsRetrieved() {
        this.restClient.authenticateUser(adminUserModel);
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains(FIELD_TAG, folderTagValue);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify site Manager is able to get tags using properties parameter.Check that properties filter is applied.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void siteManagerIsAbleToRetrieveTagsWithPropertiesParameter() {
        returnedCollection = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withParams(new String[]{"maxItems=5000&properties=tag"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains(FIELD_TAG, documentTagValue)).and().entriesListContains(FIELD_TAG, documentTagValue2)).and().entriesListDoesNotContain(FIELD_ID);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With admin get tags and use skipCount parameter. Check pagination")
    @Test(groups={"rest-api", "tags", "regression"})
    public void useSkipCountCheckPagination() {
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestTagModel firstTag = ((RestTagModel)returnedCollection.getEntries().get(0)).onModel();
        RestTagModel secondTag = ((RestTagModel)returnedCollection.getEntries().get(1)).onModel();
        RestTagModelsCollection tagsWithSkipCount = this.restClient.withParams(new String[]{"skipCount=2"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)tagsWithSkipCount.assertThat().entriesListDoesNotContain(FIELD_TAG, firstTag.getTag())).assertThat().entriesListDoesNotContain(FIELD_TAG, secondTag.getTag());
        tagsWithSkipCount.assertThat().paginationField("skipCount").is("2");
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With admin get tags and use maxItems parameter. Check pagination")
    @Test(groups={"rest-api", "tags", "regression"})
    public void useMaxItemsParameterCheckPagination() {
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestTagModel firstTag = ((RestTagModel)returnedCollection.getEntries().get(0)).onModel();
        RestTagModel secondTag = ((RestTagModel)returnedCollection.getEntries().get(1)).onModel();
        RestTagModelsCollection tagsWithMaxItems = this.restClient.withParams(new String[]{"maxItems=2"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)tagsWithMaxItems.assertThat().entriesListContains(FIELD_TAG, firstTag.getTag())).assertThat().entriesListContains(FIELD_TAG, secondTag.getTag())).assertThat().entriesListCountIs(2);
        tagsWithMaxItems.assertThat().paginationField("maxItems").is("2");
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With manager get tags and use high skipCount parameter. Check pagination")
    @Test(groups={"rest-api", "tags", "regression"})
    public void useHighSkipCountCheckPagination() {
        returnedCollection = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withParams(new String[]{"skipCount=20000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestModels)returnedCollection.assertThat().entriesListIsEmpty()).getPagination().assertThat().field("maxItems").is((Object)100)).and().field("hasMoreItems").is((Object)"false")).and().field(FIELD_COUNT).is((Object)"0")).and().field("skipCount").is((Object)20000);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With Collaborator user get tags and use maxItems with value zero. Check default error model schema")
    @Test(groups={"rest-api", "tags", "regression"})
    public void useMaxItemsWithValueZeroCheckDefaultErrorModelSchema() {
        returnedCollection = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"maxItems=0"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With Manager user delete tag. Check it is not retrieved anymore.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void checkThatDeletedTagIsNotRetrievedAnymore() {
        String removedTag = RandomData.getRandomName((String)"tag3");
        RestTagModel deletedTag = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).addTag(removedTag);
        this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingTag(deletedTag).deleteTag();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        ((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListDoesNotContain(FIELD_TAG, removedTag);
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withSingleNameFilter() {
        Step.STEP((String)"Get tags with names filter using EQUALS and expect one item in result");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"where=(tag='" + documentTag.getTag() + "')"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.assertThat().entrySetMatches(FIELD_TAG, Set.of(documentTagValue));
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withTwoNameFilters() {
        Step.STEP((String)"Get tags with names filter using IN and expect two items in result");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"where=(tag IN ('" + documentTag.getTag() + "', '" + folderTag.getTag() + "'))"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.assertThat().entrySetMatches(FIELD_TAG, Set.of(documentTagValue, folderTagValue));
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_whichNamesStartsWithOrphan() {
        Step.STEP((String)"Get tags with names filter using MATCHES and expect one item in result");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"where=(tag MATCHES ('orphan*'))", "maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.assertThat().entrySetContains(FIELD_TAG, new String[]{orphanTag.getTag()});
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withExactNameAndAlikeFilters() {
        Step.STEP((String)"Get tags with names filter using EQUALS and MATCHES and expect four items in result");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"where=(tag MATCHES ('*tag*'))", "maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.assertThat().entrySetContains(FIELD_TAG, new String[]{documentTagValue, documentTagValue2, folderTagValue, orphanTag.getTag()});
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withTwoAlikeFilters() {
        Step.STEP((String)"Get tags applying names filter using MATCHES twice and expect four items in result");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"where=(tag MATCHES ('orphan*') OR tag MATCHES ('tag*'))", "maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedCollection.assertThat().entrySetContains(FIELD_TAG, new String[]{documentTagValue, documentTagValue2, folderTagValue, orphanTag.getTag()});
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_withWrongWherePropertyNameAndExpect400() {
        Step.STEP((String)"Try to get tags with names filter using EQUALS and wrong property name and expect 400");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"where=(name=gat)"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Where query error: property with name: name is not expected");
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_queryAndOperatorNotSupported() {
        Step.STEP((String)"Try to get tags applying names filter using AND operator and expect 400");
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"where=(name=tag AND name IN ('tag-', 'gat'))"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("An invalid WHERE query was received. Unsupported Predicate");
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_includingCount() {
        Step.STEP((String)"Get tags including count and verify if it is present in the response");
        RestTagModelsCollection searchedTags = ((RestCoreAPI)this.restClient.withCoreAPI().include(new String[]{FIELD_COUNT})).getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)searchedTags.assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains(FIELD_COUNT)).assertThat().entriesListContains(FIELD_TAG)).assertThat().entriesListContains(FIELD_ID);
    }

    @Test(groups={"rest-api", "tags", "regression"})
    public void testGetTags_notIncludingCount() {
        Step.STEP((String)"Get tags, not including count and verify if it is not in the response");
        RestTagModelsCollection searchedTags = this.restClient.withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)searchedTags.assertThat().entriesListIsNotEmpty()).assertThat().entriesListDoesNotContain(FIELD_COUNT)).assertThat().entriesListContains(FIELD_TAG)).assertThat().entriesListContains(FIELD_ID);
    }
}

