/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people.activities;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestActivityModel;
import org.alfresco.rest.model.RestActivityModelsCollection;
import org.alfresco.rest.model.RestActivitySummaryModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.requests.People;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeopleActivitiesFullTests
extends RestTest {
    UserModel userModel;
    UserModel adminUser;
    UserModel managerUser;
    SiteModel siteModel1;
    SiteModel siteModel2;
    FileModel fileInSite1;
    FileModel fileInSite2;
    FolderModel folderInSite2;
    private RestActivityModelsCollection restActivityModelsCollection;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel1 = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileInSite1 = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.siteModel2 = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.folderInSite2 = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel2)).createFolder();
        this.fileInSite2 = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel2)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.managerUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(this.managerUser, this.siteModel2, UserRole.SiteManager);
        this.restActivityModelsCollection = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().getPersonActivitiesUntilEntriesCountIs(6);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restActivityModelsCollection.assertThat().paginationField("count").is("6");
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify activity summary from user gets activities response with Rest API")
    public void userGetPeopleActivitiesWithActivitySummaryCheck() throws Exception {
        this.restActivityModelsCollection = ((People)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().usingParams(new String[]{String.format("siteId=%s", this.siteModel1.getId())})).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restActivityModelsCollection.assertThat().paginationField("count").is("2");
        RestActivitySummaryModel summary = ((RestActivityModel)this.restActivityModelsCollection.getEntries().get(0)).onModel().getActivitySummary();
        ((RestActivitySummaryModel)((RestActivitySummaryModel)((RestActivitySummaryModel)summary.assertThat().field("firstName").is((Object)("FN-" + this.userModel.getUsername()))).and().field("lastName").is((Object)("LN-" + this.userModel.getUsername()))).and().field("title").is((Object)this.fileInSite1.getName())).and().field("objectId").is((Object)this.fileInSite1.getNodeRefWithoutVersion());
    }

    @Bug(id="REPO-1911")
    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot get activities for empty user with Rest API and response is 400")
    public void userCannotGetPeopleActivitiesForEmptyPersonId() throws Exception {
        UserModel emptyUserName = new UserModel("", "password");
        this.restActivityModelsCollection = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(emptyUserName).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(RestErrorModel.LOCAL_NAME_CONSISTANCE).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets its activities for siteId specified in siteId parameter using me with Rest API and response is successful")
    public void userGetItsPeopleActivitiesForASpecificSite() throws Exception {
        this.restActivityModelsCollection = ((People)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).usingParams(new String[]{String.format("siteId=%s", this.siteModel1.getId())})).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restActivityModelsCollection.assertThat().paginationField("count").is("2");
        ((RestModels)this.restActivityModelsCollection.assertThat().entriesListContains("siteId", this.siteModel1.getId())).and().entriesListDoesNotContain("siteId", this.siteModel2.getId());
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets activities for user with no activities with Rest API and response is successful")
    public void userGetPeopleActivitiesForUserWithNoActivities() throws Exception {
        UserModel userNoActivities = this.dataUser.createRandomTestUser();
        ((DataSite)this.dataSite.usingUser(userNoActivities)).createPublicRandomSite();
        this.restActivityModelsCollection = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(userNoActivities).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restActivityModelsCollection.assertThat().paginationField("count").is("0");
        this.restActivityModelsCollection.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot get activities for siteId that user doesn't have access to with Rest API and response is not found")
    public void userGetPeopleActivitiesForASiteWithNoAccess() throws Exception {
        SiteModel siteNoAccess = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPrivateRandomSite();
        this.restActivityModelsCollection = ((People)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).usingParams(new String[]{String.format("siteId=%s", siteNoAccess.getId())})).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, siteNoAccess.getId()));
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot get activities for another user with Rest API and response is permission denied")
    public void userGetPeopleActivitiesForAnotherUser() throws Exception {
        this.restActivityModelsCollection = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.managerUser).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets activities with properties parameter applied with Rest API and response is successful")
    public void userGetPeopleActivitiesUsingPropertiesParameter() throws Exception {
        this.restActivityModelsCollection = ((People)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().usingParams(new String[]{"properties=postPersonId"})).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restActivityModelsCollection.assertThat().paginationField("count").is("6");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.restActivityModelsCollection.assertThat().entriesListContains("postPersonId", this.userModel.getUsername().toLowerCase())).and().entriesListContains("postPersonId", this.adminUser.getUsername().toLowerCase())).and().entriesListContains("postPersonId", this.managerUser.getUsername().toLowerCase())).and().entriesListDoesNotContain("postedAt")).and().entriesListDoesNotContain("feedPersonId")).and().entriesListDoesNotContain("siteId")).and().entriesListDoesNotContain("activitySummary")).and().entriesListDoesNotContain("id")).and().entriesListDoesNotContain("activityType");
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets activities with skipCount parameter applied with Rest API and response is successful")
    public void userGetPeopleActivitiesUsingSkipCountParameter() throws Exception {
        this.restActivityModelsCollection = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restActivityModelsCollection.assertThat().paginationField("count").is("6");
        RestActivityModel expectedRestActivity3 = ((RestActivityModel)this.restActivityModelsCollection.getEntries().get(2)).onModel();
        RestActivityModel expectedRestActivity4 = ((RestActivityModel)this.restActivityModelsCollection.getEntries().get(3)).onModel();
        this.restActivityModelsCollection = ((People)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().usingParams(new String[]{"skipCount=2"})).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restActivityModelsCollection.assertThat().paginationField("count").is("4");
        ((RestActivityModel)((RestActivityModel)this.restActivityModelsCollection.getEntries().get(0)).onModel().assertThat().field("postPersonId").is((Object)expectedRestActivity3.getPostPersonId())).and().field("activityType").is((Object)expectedRestActivity3.getActivityType());
        ((RestActivityModel)((RestActivityModel)this.restActivityModelsCollection.getEntries().get(1)).onModel().assertThat().field("postPersonId").is((Object)expectedRestActivity4.getPostPersonId())).and().field("activityType").is((Object)expectedRestActivity4.getActivityType());
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets activities with maxItems parameter applied with Rest API and response is successful")
    public void userGetPeopleActivitiesUsingMaxItemsParameter() throws Exception {
        this.restActivityModelsCollection = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restActivityModelsCollection.assertThat().paginationField("count").is("6");
        RestActivityModel expectedRestActivity1 = ((RestActivityModel)this.restActivityModelsCollection.getEntries().get(0)).onModel();
        RestActivityModel expectedRestActivity2 = ((RestActivityModel)this.restActivityModelsCollection.getEntries().get(1)).onModel();
        this.restActivityModelsCollection = ((People)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().usingParams(new String[]{"maxItems=2"})).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restActivityModelsCollection.assertThat().paginationField("count").is("2");
        ((RestActivityModel)((RestActivityModel)this.restActivityModelsCollection.getEntries().get(0)).onModel().assertThat().field("postPersonId").is((Object)expectedRestActivity1.getPostPersonId())).and().field("activityType").is((Object)expectedRestActivity1.getActivityType());
        ((RestActivityModel)((RestActivityModel)this.restActivityModelsCollection.getEntries().get(1)).onModel().assertThat().field("postPersonId").is((Object)expectedRestActivity2.getPostPersonId())).and().field("activityType").is((Object)expectedRestActivity2.getActivityType());
    }
}

