/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processDefinitions;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.rest.model.RestProcessDefinitionModelsCollection;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessDefinitionFullTests
extends RestTest {
    private UserModel adminUser;
    private RestProcessDefinitionModel randomProcessDefinition;
    private RestProcessDefinitionModel returnedProcessDefinition;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify if get process definition returns all process definitions when empty processDefinitionId is used")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionUsingEmptyProcessDefinitionId() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI();
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"/process-definitions/{processDefinitionId}", (String[])new String[]{""});
        RestProcessDefinitionModelsCollection processDefinitions = (RestProcessDefinitionModelsCollection)this.restClient.processModels(RestProcessDefinitionModelsCollection.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        processDefinitions.assertThat().entriesListIsNotEmpty();
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets a process definition with properties parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionWithValidProperties() throws Exception {
        this.randomProcessDefinition = ((RestProcessDefinitionModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getAllProcessDefinitions().getOneRandomEntry()).onModel();
        this.returnedProcessDefinition = this.restClient.withParams(new String[]{"properties=id,name,graphicNotationDefined,version"}).withWorkflowAPI().usingProcessDefinitions(this.randomProcessDefinition).getProcessDefinition();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)this.returnedProcessDefinition.assertThat().fieldsCount().is((Object)4)).and().field("deploymentId").isNull()).and().field("description").isNull()).and().field("id").is((Object)this.randomProcessDefinition.getId())).and().field("startFormResourceKey").isNull()).and().field("category").isNull()).and().field("title").isNull()).and().field("version").is((Object)this.randomProcessDefinition.getVersion())).and().field("graphicNotationDefined").is((Object)this.randomProcessDefinition.getGraphicNotationDefined())).and().field("key").isNull()).and().field("name").is((Object)this.randomProcessDefinition.getName());
    }
}

