/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestSiteEntry;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteMembershipSanityTests
extends RestTest {
    private SiteModel siteModel;
    private UserModel adminUser;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to retrieve site membership information of another user")
    public void siteManagerCanRetrieveSiteMembershipInformation() throws JsonToModelConversionException, Exception {
        ((RestSiteEntry)((RestSiteEntry)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingUser(this.adminUser).getSiteMembership(this.siteModel).assertThat().field("role").is((Object)UserRole.SiteManager)).and().field("id").is((Object)this.siteModel.getId())).and().field("site").isNotEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site collaborator is able to retrieve site membership information of another user")
    public void siteCollaboratorCanRetrieveSiteMembershipInformation() throws JsonToModelConversionException, Exception {
        ((RestSiteModel)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.adminUser).getSiteMembership(this.siteModel).onSite().assertThat().field("role").is((Object)UserRole.SiteCollaborator)).and().field("id").is((Object)this.siteModel.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site contributor is able to retrieve site membership information of another user")
    public void siteContributorCanRetrieveSiteMembershipInformation() throws JsonToModelConversionException, Exception {
        ((RestSiteEntry)((RestSiteEntry)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingUser(this.adminUser).getSiteMembership(this.siteModel).assertThat().field("role").is((Object)UserRole.SiteManager)).and().field("id").is((Object)this.siteModel.getId())).and().field("site").isNotEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site consumer is able to retrieve site membership information of another user")
    public void siteConsumerCanRetrieveSiteMembershipInformation() throws JsonToModelConversionException, Exception {
        ((RestSiteEntry)((RestSiteEntry)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(this.adminUser).getSiteMembership(this.siteModel).assertThat().field("role").is((Object)UserRole.SiteManager)).and().field("id").is((Object)this.siteModel.getId())).and().field("site").isNotEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify admin user is able to retrieve site membership information of another user")
    public void adminCanRetrieveSiteMembershipInformation() throws JsonToModelConversionException, Exception {
        ((RestSiteEntry)((RestSiteEntry)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).getSiteMembership(this.siteModel).assertThat().field("role").is((Object)UserRole.SiteManager)).and().field("id").is((Object)this.siteModel.getId())).and().field("site").isNotEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user is not able to retrieve site membership information of another user")
    public void unauthenticatedUserCannotRetrieveSiteMembershipInformation() throws JsonToModelConversionException, Exception {
        this.restClient.authenticateUser(new UserModel("random user", "random password")).withCoreAPI().usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).getSiteMembership(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

