/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.content;

import java.util.Map;
import java.util.stream.Stream;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.repo.resource.Files;
import org.alfresco.rest.repo.resource.content.RepoFolderCreator;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.repo.resource.general.MultiCreator;
import org.alfresco.rest.repo.resource.general.Specifier;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.TagModel;

public class MultiContentCreator
extends RepoFolderCreator
implements Specifier.MultiContentSpecifier {
    private final RestWrapper restClient;
    private final Files files;

    protected MultiContentCreator(DataContent dataContent, RestWrapper restClient, Files files, Map<String, FolderModel> folders) {
        super(dataContent, folders);
        this.files = files;
        this.restClient = restClient;
    }

    @Override
    public Creator.FileCreator file(String name) {
        return (Creator.FileCreator)((Creator.FileCreator)((Creator.FileCreator)this.files.add().file(name).underFolder(this.parent)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public Creator.FileCreator randomFile() {
        return (Creator.FileCreator)((Creator.FileCreator)((Creator.FileCreator)this.files.add().randomFile().underFolder(this.parent)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public Creator.FileCreator randomFile(String prefix) {
        return (Creator.FileCreator)((Creator.FileCreator)((Creator.FileCreator)this.files.add().randomFile(prefix).underFolder(this.parent)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public MultiCreator.FilesCreator files(String ... names) {
        return (MultiCreator.FilesCreator)((MultiCreator.FilesCreator)((MultiCreator.FilesCreator)this.files.add().files(names).underFolder(this.parent)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public MultiCreator.FilesCreator randomFiles(String ... prefixes) {
        return (MultiCreator.FilesCreator)((MultiCreator.FilesCreator)((MultiCreator.FilesCreator)this.files.add().randomFiles(prefixes).underFolder(this.parent)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public MultiCreator.FilesCreator randomFiles(int quantity) {
        return (MultiCreator.FilesCreator)((MultiCreator.FilesCreator)((MultiCreator.FilesCreator)this.files.add().randomFiles(quantity).underFolder(this.parent)).withinSite(this.site)).asUser(this.user);
    }

    public void secondaryContent(ContentModel content) {
        this.buildNodeRestRequest(this.restClient, (RepoTestModel)this.parent).addSecondaryChild((RepoTestModel)content);
    }

    public void secondaryContent(ContentModel ... contents) {
        this.buildNodeRestRequest(this.restClient, (RepoTestModel)this.parent).addSecondaryChildren((RepoTestModel[])contents);
    }

    public void tag(RestTagModel tag) {
        this.buildNodeRestRequest(this.restClient, (RepoTestModel)this.parent).addTag(tag.getTag());
    }

    public void tags(RestTagModel ... tags) {
        this.buildNodeRestRequest(this.restClient, (RepoTestModel)this.parent).addTags((String[])Stream.of(tags).map(TagModel::getTag).toArray(String[]::new));
    }
}

