/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteProcessSanityTests
extends RestTest {
    private UserModel userWhoAddsProcess;
    private UserModel assignee;
    private UserModel anotherUser;
    private RestProcessModel process;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoAddsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.anotherUser = this.dataUser.createRandomTestUser();
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Verify User is able to delete process started by him using REST API and status code is OK (204)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void deleteProcessByUserWhoStartedProcess() throws Exception {
        this.process = this.restClient.authenticateUser(this.userWhoAddsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.process).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().getProcesses().assertThat().entriesListDoesNotContain("id", this.process.getId());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Verify User is able to delete process assigned to him using REST API and status code is OK (204)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void deleteProcessByAssignedUser() throws Exception {
        this.process = this.restClient.authenticateUser(this.userWhoAddsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.process).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().getProcesses().assertThat().entriesListDoesNotContain("id", this.process.getId());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Verify User that is not involved in a process is not authorized to delete it using REST API and status code is 403")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void deleteProcessByAnotherUser() throws Exception {
        this.process = this.restClient.authenticateUser(this.userWhoAddsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.anotherUser).withWorkflowAPI().usingProcess((ProcessModel)this.process).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("user is not allowed to access information about process");
    }
}

