/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests.search;

import io.restassured.RestAssured;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.rest.search.SearchSqlJDBCRequest;

public class SearchSQLJDBC
extends ModelRequest<SearchSQLJDBC> {
    public SearchSQLJDBC(RestWrapper restWrapper) {
        super(restWrapper);
        RestAssured.basePath = "alfresco/api/-default-/public/search/versions/1/sql";
        restWrapper.configureRequestSpec().setBasePath(RestAssured.basePath);
    }

    public ResultSet executeQueryViaJDBC(SearchSqlJDBCRequest query) throws SQLException {
        StringBuilder connectionString = new StringBuilder().append(RestAssured.baseURI.replaceAll("http", "jdbc:alfresco").replaceAll("https", "jdbc:alfresco")).append(":").append(RestAssured.port).append("/").append(RestAssured.basePath).append("/");
        String sql = null == query.getSql() || query.getSql().isEmpty() ? "" : query.getSql();
        Properties auth = new Properties();
        auth.put("user", query.getAuthUser().getUsername());
        auth.put("password", query.getAuthUser().getPassword());
        try {
            query.setConnection(DriverManager.getConnection(connectionString.toString(), auth));
            query.setStmt(query.getConnection().createStatement());
            query.setResultSet(query.getStmt().executeQuery(sql));
        }
        catch (SQLException eSql) {
            query.setErrorDetails(eSql.getMessage());
        }
        return query.getResultSet();
    }

    public void clearSearchQuery(SearchSqlJDBCRequest query) throws SQLException {
        if (query.getResultSet() != null) {
            query.getResultSet().close();
        }
        if (query.getStmt() != null) {
            query.getStmt().close();
        }
        if (query.getConnection() != null) {
            query.getConnection().close();
        }
    }
}

