/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddTaskItemTestsBulk3
extends RestTest {
    private UserModel userModel;
    private UserModel userWhoStartsTask;
    private UserModel assigneeUser;
    private SiteModel siteModel;
    private FileModel fileModel;
    private FileModel fileModel1;
    private FileModel document1;
    private FileModel document2;
    private FileModel document3;
    private TaskModel taskModel;
    private RestItemModelsCollection taskItems;
    private RestItemModel taskItem;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assigneeUser = this.dataUser.createRandomTestUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Add task item using random user.")
    public void addTaskItemByTheUserThatStartedTheProcess() throws Exception {
        this.taskItem = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.fileModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.taskItem.assertThat().field("createdAt").is((Object)this.taskItem.getCreatedAt())).and().field("size").is((Object)this.taskItem.getSize())).and().field("createdBy").is((Object)this.taskItem.getCreatedBy())).and().field("modifiedAt").is((Object)this.taskItem.getModifiedAt())).and().field("name").is((Object)this.taskItem.getName())).and().field("modifiedBy").is((Object)this.taskItem.getModifiedBy())).and().field("id").is((Object)this.taskItem.getId())).and().field("mimeType").is((Object)this.taskItem.getMimeType());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Add multiple task item using random user.")
    public void addMultipleTaskItemByTheUserThatStartedTheProcess() throws Exception {
        this.fileModel1 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.taskItems = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingTask(this.taskModel).addTaskItems(new FileModel[]{this.fileModel, this.fileModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().assertThat().field("createdAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getCreatedAt())).and().field("size").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getSize())).and().field("createdBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getCreatedBy())).and().field("modifiedAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getModifiedAt())).and().field("name").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getName())).and().field("modifiedBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getModifiedBy())).and().field("id").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getId())).and().field("mimeType").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getMimeType());
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().assertThat().field("createdAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getCreatedAt())).assertThat().field("size").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getSize())).assertThat().field("createdBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getCreatedBy())).assertThat().field("modifiedAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getModifiedAt())).assertThat().field("name").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getName())).assertThat().field("modifiedBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getModifiedBy())).assertThat().field("id").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getId())).assertThat().field("mimeType").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getMimeType());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete task item then create it again")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskItemThenCreateItAgain() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete multiple task item then create it again")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteMultipleTaskItemsThenCreateThemAgain() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.document1 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.document3 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItems = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItems(new FileModel[]{this.document2, this.document1, this.document3});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(((RestItemModel)this.taskItems.getEntries().get(0)).onModel());
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(((RestItemModel)this.taskItems.getEntries().get(1)).onModel());
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(((RestItemModel)this.taskItems.getEntries().get(2)).onModel());
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItems(new FileModel[]{this.document2, this.document1, this.document3});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }
}

