/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests.search;

import io.restassured.RestAssured;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import java.util.ArrayList;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestTextResponse;
import org.alfresco.rest.requests.ModelRequest;
import org.springframework.http.HttpMethod;

public class SolrAPI
extends ModelRequest<SolrAPI> {
    public SolrAPI(RestWrapper restWrapper) {
        super(restWrapper);
        RestAssured.basePath = "solr/alfresco";
        restWrapper.configureSolrEndPoint();
        restWrapper.configureRequestSpec().setBasePath(RestAssured.basePath);
    }

    public RestTextResponse getConfig() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "config?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processTextResponse(request);
    }

    public RestTextResponse getConfigOverlay() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "config/overlay?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processTextResponse(request);
    }

    public RestTextResponse getConfigParams() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "config/params?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processTextResponse(request);
    }

    public RestTextResponse postConfig(String queryBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, queryBody, "config", new String[0]);
        return this.restWrapper.processTextResponse(request);
    }

    public RestTextResponse postAction(String urlActionPath, String queryBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, queryBody, urlActionPath, new String[0]);
        return this.restWrapper.processTextResponse(request);
    }

    public RestTextResponse getSelectQuery() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new Header("Content-Type", "application/xml"));
        Headers header = new Headers(headers);
        this.restWrapper.setResponseHeaders(header);
        this.restWrapper.configureRequestSpec().setUrlEncodingEnabled(false);
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "select?q={parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processTextResponse(request);
    }

    public RestTextResponse getSelectQueryJson() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new Header("Content-Type", "application/json"));
        Headers header = new Headers(headers);
        this.restWrapper.setResponseHeaders(header);
        this.restWrapper.configureRequestSpec().setUrlEncodingEnabled(false);
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "select?q={parameters}&wt=json", this.restWrapper.getParameters());
        return this.restWrapper.processTextResponse(request);
    }
}

