package org.alfresco.rest.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'mpichura' on '2022-12-01 13:41' from 'Alfresco Content Services REST API' swagger file Generated from 'Alfresco Content Services REST API' swagger file Base Path {@linkplain /alfresco/api/-default-/public/alfresco/versions/1}
 */
public class RestCategoryLinkBodyModel extends TestModel implements IRestModel<RestCategoryLinkBodyModel>
{
    @JsonProperty(value = "entry")
    RestCategoryLinkBodyModel model;

    @Override
    public RestCategoryLinkBodyModel onModel()
    {
        return model;
    }

    /**
     * The identifier of the category.
     */

    @JsonProperty(required = true)
    private String categoryId;

    public String getCategoryId()
    {
        return categoryId;
    }

    public void setCategoryId(String categoryId)
    {
        this.categoryId = categoryId;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        RestCategoryLinkBodyModel that = (RestCategoryLinkBodyModel) o;
        return Objects.equals(categoryId, that.categoryId);
    }

    @Override
    public int hashCode()
    {
        return Objects.hash(categoryId);
    }

    @Override
    public String toString()
    {
        return "RestCategoryLinkBodyModel{" + "categoryId='" + categoryId + '\'' + '}';
    }

    public static Builder builder()
    {
        return new Builder();
    }

    public static class Builder
    {
        private String categoryId;

        public Builder categoryId(String categoryId)
        {
            this.categoryId = categoryId;
            return this;
        }

        public RestCategoryLinkBodyModel create()
        {
            final RestCategoryLinkBodyModel categoryLink = new RestCategoryLinkBodyModel();
            categoryLink.setCategoryId(categoryId);
            return categoryLink;
        }
    }
}
