/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteEntry;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteMembershipFullTests
extends RestTest {
    UserModel regularUser;
    UserModel adminUser;
    SiteModel publicSite;
    SiteModel moderatedSite;
    private DataUser.ListUserWithRoles publicSiteUsers;
    private RestSiteEntry restSiteEntry;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.regularUser = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        this.publicSiteUsers = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that properties parameter is applied.")
    public void checkThatPropertiesParameterIsApplied() throws Exception {
        this.restSiteEntry = ((RestCoreAPI)this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingParams(new String[]{"properties=site,role,id"})).usingUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteManager)).getSiteMembership(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)this.restSiteEntry.assertThat().field("role").is((Object)UserRole.SiteManager)).and().field("id").is((Object)this.publicSite.getId())).and().field("site").isNotEmpty()).and().field("guid").isNull();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that regular user is able to retrieve site membership information of admin.")
    public void regularUserGetsSiteMembershipForAdmin() throws Exception {
        this.restSiteEntry = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingUser(this.adminUser).getSiteMembership(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteEntry)((RestSiteEntry)this.restSiteEntry.assertThat().field("role").is((Object)UserRole.SiteManager)).and().field("id").is((Object)this.publicSite.getId())).and().field("site.id").is((Object)this.publicSite.getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that regular user is able to retrieve site membership details for a Collaborator role.")
    public void getSiteMembershipDetailsForACollaboratorRole() throws Exception {
        this.restSiteEntry = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator)).getSiteMembership(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)this.restSiteEntry.assertThat().field("role").is((Object)UserRole.SiteCollaborator)).and().field("guid").is((Object)this.publicSite.getGuid())).and().field("id").is((Object)this.publicSite.getId())).and().field("site.visibility").is((Object)this.publicSite.getVisibility().toString())).and().field("site.guid").is((Object)this.publicSite.getGuid())).and().field("site.description").is((Object)this.publicSite.getDescription())).and().field("site.id").is((Object)this.publicSite.getId())).and().field("site.preset").is((Object)"site-dashboard")).and().field("site.title").is((Object)this.publicSite.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that regular user is able to retrieve site membership details for a Contributor role.")
    public void getSiteMembershipDetailsForAContributorRole() throws Exception {
        this.restSiteEntry = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteContributor)).getSiteMembership(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteEntry)((RestSiteEntry)this.restSiteEntry.assertThat().field("role").is((Object)UserRole.SiteContributor)).and().field("id").is((Object)this.publicSite.getId())).and().field("site").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that regular user is able to retrieve site membership details for a Consumer role.")
    public void getSiteMembershipDetailsForAConsumerRole() throws Exception {
        this.restSiteEntry = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteConsumer)).getSiteMembership(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteEntry)((RestSiteEntry)this.restSiteEntry.assertThat().field("role").is((Object)UserRole.SiteConsumer)).and().field("id").is((Object)this.publicSite.getId())).and().field("site").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="As regular user make a request to join a moderated site. The request is pending. Check membership details.")
    public void pendingRequestToASiteCheckMembershipDetails() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restSiteEntry = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(this.regularUser).getSiteMembership(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.regularUser.getUsername(), this.moderatedSite.getTitle()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="As Collaborator user leave site and perform get call.Check default error model schema.")
    public void leaveSiteAndPerformGetCallCheckDefaultErrorModelSchema() throws Exception {
        UserModel leaveSiteUser = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(leaveSiteUser, this.publicSite, UserRole.SiteCollaborator);
        this.restClient.authenticateUser(leaveSiteUser).withCoreAPI().usingAuthUser().deleteSiteMember(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restSiteEntry = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(leaveSiteUser).getSiteMembership(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, leaveSiteUser.getUsername(), this.publicSite.getTitle())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

