package org.alfresco.rest.search;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'krystian' on '2023-06-12 18:46' from 'Alfresco Content Services REST API' swagger file Generated from 'Alfresco Content Services REST API' swagger file Base Path {@linkplain /alfresco/api/-default-/public/search/versions/1}
 */
public class RestRequestTemplatesModel extends TestModel implements IRestModel<RestRequestTemplatesModel>
{
    @JsonProperty(value = "entry")
    RestRequestTemplatesModel model;

    @Override
    public RestRequestTemplatesModel onModel()
    {
        return model;
    }

    private String name;

    private String template;

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public String getTemplate()
    {
        return template;
    }

    public void setTemplate(String template)
    {
        this.template = template;
    }

    @Override
    public String toString()
    {
        return "RestRequestTemplatesModel{" + "name='" + name + '\'' + ", template='" + template + '\'' + '}';
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        RestRequestTemplatesModel that = (RestRequestTemplatesModel) o;
        return Objects.equals(name, that.name) && Objects.equals(template, that.template);
    }

    @Override
    public int hashCode()
    {
        return Objects.hash(name, template);
    }

    public static Builder builder()
    {
        return new Builder();
    }

    public static class Builder
    {
        private String name;
        private String template;

        public Builder name(String name)
        {
            this.name = name;
            return this;
        }

        public Builder template(String template)
        {
            this.template = template;
            return this;
        }

        public RestRequestTemplatesModel create()
        {
            RestRequestTemplatesModel template = new RestRequestTemplatesModel();
            template.setName(this.name);
            template.setTemplate(this.template);

            return template;
        }
    }
}
