/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.ratings;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.model.RestRatingModelsCollection;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetRatingsTests
extends RestTest {
    private SiteModel siteModel;
    private UserModel adminUser;
    private UserModel userModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private RestRatingModelsCollection restRatingModelsCollection;
    private FileModel document;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Manager is able to retrieve document ratings")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void managerIsAbleToRetrieveDocumentRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restRatingModelsCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restRatingModelsCollection.assertNodeHasFiveStarRating().assertNodeIsLiked();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Collaborator is able to retrieve document ratings")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void collaboratorIsAbleToRetrieveDocumentRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restRatingModelsCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restRatingModelsCollection.assertNodeHasFiveStarRating().assertNodeIsLiked();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Contributor is able to retrieve document ratings")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void contributorIsAbleToRetrieveDocumentRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restRatingModelsCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restRatingModelsCollection.assertNodeHasFiveStarRating().assertNodeIsLiked();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Consumer is able to retrieve document ratings")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void consumerIsAbleToRetrieveDocumentRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restRatingModelsCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restRatingModelsCollection.assertNodeHasFiveStarRating().assertNodeIsLiked();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Admin user is able to retrieve document ratings")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void adminIsAbleToRetrieveDocumentRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.document = ((DataContent)this.dataContent.usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restRatingModelsCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restRatingModelsCollection.assertNodeHasFiveStarRating().assertNodeIsLiked();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user is not able to retrieve document ratings")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void unauthenticatedUserIsNotAbleToRetrieveRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restClient.authenticateUser(new UserModel("random user", "random password"));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Check that rating for invalid maxItems status code is 400")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void checkInvalidMaxItemsStatusCode() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).likeDocument();
        this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=0"}).withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Only positive values supported for maxItems");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Check that rating for invalid skipCount status code is 400")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void checkInvalidSkipCountStatusCode() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).likeDocument();
        this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"skipCount=AB"}).withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Invalid paging parameter skipCount:AB");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="If nodeId does not exist status code is 404 when a document is liked")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addLikeUsingInvalidNodeId() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).likeDocument();
        this.document.setNodeRef(RandomStringUtils.randomAlphanumeric((int)20));
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.document.getNodeRef()));
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Check that rating value is TRUE for a like rating")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void checkRatingValueIsTrueForLikedDoc() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).likeDocument();
        this.restRatingModelsCollection = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.restRatingModelsCollection.assertThat().entriesListContains("myRating", "true")).assertThat().entriesListContains("id", "likes");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Check that rating value is an INTEGER value for stars rating")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void checkRatingValueIsIntegerForStarsRating() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).likeDocument();
        this.restRatingModelsCollection = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.restRatingModelsCollection.assertThat().entriesListContains("myRating", "5")).assertThat().entriesListContains("id", "fiveStar");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Check default error schema in case of failure")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void checkDefaultErrorSchema() throws Exception {
        FileModel document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        document.setNodeRef("abc");
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "abc")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Check maxItems and skipCount parameters")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void checkMaxItemsAndSkipCountParameters() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).likeDocument();
        this.restRatingModelsCollection = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=1", "skipCount=1"}).withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restRatingModelsCollection.assertThat().entriesListCountIs(1);
        ((RestPaginationModel)this.restRatingModelsCollection.getPagination().assertThat().field("maxItems").is((Object)"1")).and().field("skipCount").is((Object)"1");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Check totalItems and hasMoreitems parameters")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void checkTotalItemsAndHasMoreItemsParameters() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).likeDocument();
        this.restRatingModelsCollection = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=1"}).withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restRatingModelsCollection.assertThat().entriesListCountIs(1);
        ((RestPaginationModel)((RestPaginationModel)this.restRatingModelsCollection.getPagination().assertThat().field("hasMoreItems").is((Object)"true")).and().field("count").is((Object)"1")).and().field("maxItems").is((Object)"1");
    }

    @Bug(id="REPO-1831")
    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get ratings for a document to which authenticated user does not have access")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void userIsNotAbleToGetRatingsOfDocumentToWhichItHasNoAccess() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FileModel file = ((DataContent)this.dataContent.usingSite(privateSite)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restRatingModelsCollection = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingResource((RepoTestModel)file).getRatings();
        this.restRatingModelsCollection.assertThat().entriesListIsEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Check high value for skipCount parameter")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingsUsingHighValueForSkipCount() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingNode((RepoTestModel)this.document).likeDocument();
        this.restRatingModelsCollection = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"skipCount=100"}).withCoreAPI().usingResource((RepoTestModel)this.document).getRatings();
        this.restRatingModelsCollection.getPagination().assertThat().field("skipCount").is((Object)"100");
        this.restRatingModelsCollection.assertThat().entriesListIsEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get ratings using site id instead of node id")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingsUsingSiteId() throws Exception {
        FileModel document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        document.setNodeRef(this.siteModel.getId());
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.siteModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

