/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.model.RestTagModelsCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.springframework.http.HttpMethod;

public class Tags
extends ModelRequest<Tags> {
    RestTagModel tag;

    public Tags(RestTagModel tag, RestWrapper restWrapper) {
        super(restWrapper);
        this.tag = tag;
    }

    public RestTagModelsCollection getTags() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "tags?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestTagModelsCollection.class, request);
    }

    public RestTagModel getTag() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "tags/{tagId}?{parameters}", this.tag.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestTagModel.class, request);
    }

    public RestTagModel update(String newTag) {
        String postBody = JsonBodyGenerator.keyValueJson("tag", newTag);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, postBody, "tags/{tagId}", this.tag.getId());
        return this.restWrapper.processModel(RestTagModel.class, request);
    }

    public void deleteTag() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "/tags/{tagId}", this.tag.getId());
        this.restWrapper.processEmptyModel(request);
    }
}

