/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.content;

import java.util.Map;
import org.alfresco.rest.repo.resource.content.SerialFilesCreator;
import org.alfresco.rest.repo.resource.general.ContentCreator;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.repo.resource.general.MultiCreator;
import org.alfresco.rest.repo.resource.general.Specifier;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;

public class PlainFileCreator
extends ContentCreator<FileModel, Creator.FileCreator>
implements Creator.FileCreator,
Specifier.FileSpecifier {
    private final DataContent dataContent;
    private final Map<String, FileModel> filesCache;

    public PlainFileCreator(DataContent dataContent, Map<String, FileModel> filesCache) {
        super(new FileModel());
        this.dataContent = dataContent;
        this.filesCache = filesCache;
        ((FileModel)this.contentModel).setFileType(FileType.TEXT_PLAIN);
    }

    @Override
    protected Creator.FileCreator self() {
        return this;
    }

    @Override
    public Creator.FileCreator withRandomName(String prefix) {
        this.withAlias(prefix);
        return (Creator.FileCreator)super.withRandomName(prefix);
    }

    @Override
    public Creator.FileCreator file(String name) {
        return (Creator.FileCreator)this.withName(name);
    }

    @Override
    public Creator.FileCreator randomFile() {
        return (Creator.FileCreator)this.withRandomName();
    }

    @Override
    public Creator.FileCreator randomFile(String prefix) {
        return this.withRandomName(prefix);
    }

    @Override
    public MultiCreator.FilesCreator files(String ... names) {
        return (MultiCreator.FilesCreator)((MultiCreator.FilesCreator)((MultiCreator.FilesCreator)new SerialFilesCreator(this.dataContent, this.filesCache).withNames(names)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public MultiCreator.FilesCreator randomFiles(String ... prefixes) {
        return (MultiCreator.FilesCreator)((MultiCreator.FilesCreator)((MultiCreator.FilesCreator)new SerialFilesCreator(this.dataContent, this.filesCache).withRandomNames(prefixes)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public MultiCreator.FilesCreator randomFiles(int quantity) {
        return (MultiCreator.FilesCreator)((MultiCreator.FilesCreator)((MultiCreator.FilesCreator)new SerialFilesCreator(this.dataContent, this.filesCache).withRandomNames(quantity)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public Creator.FileCreator ofType(FileType fileType) {
        ((FileModel)this.contentModel).setFileType(fileType);
        return this;
    }

    @Override
    public Creator.FileCreator withContent(String fileContent) {
        ((FileModel)this.contentModel).setContent(fileContent);
        return this;
    }

    @Override
    public FileModel create() {
        ((FileModel)this.contentModel).setName(((FileModel)this.contentModel).getName() + "." + ((FileModel)this.contentModel).getFileType().extension);
        FileModel createdFile = this.create(this.dataContent, arg_0 -> ((DataContent)this.dataContent).createContent(arg_0));
        this.filesCache.put(this.alias, createdFile);
        return createdFile;
    }

    @Override
    protected String generateRandomName() {
        return this.generateRandomNameWith("");
    }

    @Override
    protected String generateRandomNameWith(String prefix, String suffix) {
        return super.generateRandomNameWith("file" + prefix + "_", suffix);
    }
}

