/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.category;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.repo.resource.Categories;
import org.alfresco.rest.repo.resource.category.RepoCategoryCreator;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.repo.resource.general.MultiCreator;
import org.alfresco.rest.repo.resource.general.MultipleResourcesCreator;

public class SerialCategoriesCreator
extends MultipleResourcesCreator<RestCategoryModel, MultiCreator.CategoriesCreator>
implements MultiCreator.CategoriesCreator {
    private final RestWrapper restClient;
    protected RestCategoryModel parent = Categories.ROOT_CATEGORY;
    private final Map<String, RestCategoryModel> categoriesCache;

    public SerialCategoriesCreator(RestWrapper restClient, Map<String, RestCategoryModel> categoriesCache) {
        this.restClient = restClient;
        this.categoriesCache = categoriesCache;
    }

    @Override
    protected MultiCreator.CategoriesCreator self() {
        return this;
    }

    public MultiCreator.CategoriesCreator underCategory(RestCategoryModel parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public List<RestCategoryModel> create() {
        return this.createRawCategories(this.parent, this.names);
    }

    @Override
    protected String generateRandomName() {
        return this.generateRandomNameWith("");
    }

    @Override
    protected String generateRandomNameWith(String prefix) {
        return super.generateRandomNameWith("category" + prefix + "_");
    }

    private List<RestCategoryModel> createRawCategories(RestCategoryModel parent, List<String> categoryNames) {
        ArrayList<RestCategoryModel> createdCategories = new ArrayList<RestCategoryModel>();
        AtomicInteger i = new AtomicInteger();
        categoryNames.forEach(categoryName -> {
            RestCategoryModel createdCategory = this.createCategory((String)categoryName, (String)this.getOrNull(this.aliases, i.getAndIncrement()), parent);
            createdCategories.add(createdCategory);
        });
        return createdCategories;
    }

    protected RestCategoryModel createCategory(String name, String alias, RestCategoryModel parent) {
        return (RestCategoryModel)((Creator.CategoryCreator)((Creator.CategoryCreator)((Creator.CategoryCreator)new RepoCategoryCreator(this.restClient, this.categoriesCache).withAlias(alias)).withName(name)).underCategory(parent).asUser(this.user)).create();
    }
}

