/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core.swagger;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import org.alfresco.rest.core.swagger.SwaggerRequest;
import org.apache.commons.io.FilenameUtils;

public class SwaggerPaths {
    private Swagger swagger;
    private BufferedWriter fileWithMissingRequests;
    private BufferedWriter fileWithImplementedRequests;
    private String swaggerFilePath;
    private int implementedRequestCount = 0;
    private int missingRequestCount = 0;

    public SwaggerPaths(Swagger swagger, String swaggerFilePath) {
        this.swagger = swagger;
        this.swaggerFilePath = swaggerFilePath;
    }

    public void computeCoverage() {
        try {
            System.out.println("Start computing the coverage of TAS vs Swagger file. Stand by...");
            File missingReq = new File(String.format("missing-requests-%s.txt", FilenameUtils.getBaseName((String)this.swaggerFilePath)));
            missingReq.delete();
            this.fileWithMissingRequests = new BufferedWriter(new FileWriter(missingReq));
            this.fileWithMissingRequests.write(String.format("BasePath: {%s}", this.swagger.getBasePath()));
            this.fileWithMissingRequests.newLine();
            this.fileWithMissingRequests.write("These requests generated should be analyzed and modified according to your needs.");
            this.fileWithMissingRequests.newLine();
            this.fileWithMissingRequests.write("PLEASE UPDATE your 'RestReturnedModel' name with the appropiate returned model by your request.");
            this.fileWithMissingRequests.newLine();
            this.fileWithMissingRequests.newLine();
            File implReq = new File(String.format("implemented-requests-%s.txt", FilenameUtils.getBaseName((String)this.swaggerFilePath)));
            implReq.delete();
            this.fileWithImplementedRequests = new BufferedWriter(new FileWriter(implReq));
            for (Map.Entry path : this.swagger.getPaths().entrySet()) {
                for (Map.Entry<HttpMethod, Operation> entry : ((Path)path.getValue()).getOperationMap().entrySet()) {
                    this.searchPattern((String)path.getKey(), entry);
                }
            }
            System.out.println(this.toString());
            this.fileWithImplementedRequests.close();
            this.fileWithMissingRequests.close();
            if (this.missingRequestCount > 0) {
                System.out.println("[ERROR] PLEASE ANALYSE THE GENERATED <missing-requests> file(s), it seems some request were NOT implemented!");
            } else {
                missingReq.delete();
            }
            System.out.println("ALSO ANALYZE <implemented-requests.txt> for current implementation, take a look at duplicated requests if any!");
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while trying to create coverage report.", e);
        }
    }

    private void searchPattern(String pathUrl, Map.Entry<HttpMethod, Operation> operation) {
        String originalPathUrl = pathUrl;
        String httpMethod = operation.getKey().name();
        if (pathUrl.startsWith("/")) {
            pathUrl = pathUrl.substring(1, pathUrl.length());
        }
        if (pathUrl.contains("{")) {
            pathUrl = pathUrl.replace("{", "\\{");
        }
        String patternRegEx = String.format(".*HttpMethod.%s.*\\\"%s\\\"?.*", httpMethod, pathUrl);
        File project = Paths.get(".", new String[0]).toAbsolutePath().normalize().toFile();
        java.nio.file.Path requestsPath = Paths.get(project.getPath(), "src/main/java/org/alfresco/rest/requests");
        try (DirectoryStream<java.nio.file.Path> directoryStream = Files.newDirectoryStream(requestsPath);){
            boolean found = false;
            for (java.nio.file.Path path : directoryStream) {
                String line;
                if (!Files.isRegularFile(path, new LinkOption[0]) || !Files.isReadable(path)) continue;
                FileInputStream fis = new FileInputStream(path.toFile());
                InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    if (!line.matches(patternRegEx)) continue;
                    this.fileWithImplementedRequests.write(String.format("%-10s %-60s %s", httpMethod, pathUrl, path.getFileName()));
                    this.fileWithImplementedRequests.newLine();
                    this.fileWithImplementedRequests.flush();
                    ++this.implementedRequestCount;
                    found = true;
                }
                br.close();
            }
            if (!found) {
                this.fileWithMissingRequests.write(String.format("%-10s %-60s %s", httpMethod, originalPathUrl, patternRegEx));
                this.fileWithMissingRequests.newLine();
                SwaggerRequest swaggerReqModel = new SwaggerRequest(httpMethod, pathUrl, operation.getValue());
                this.fileWithMissingRequests.write(swaggerReqModel.getRequestSample());
                this.fileWithMissingRequests.flush();
                ++this.missingRequestCount;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("|\n").append("|------------------------------------------------------------------------\n").append("COVERAGE: ").append(this.swaggerFilePath).append("\n");
        int percentage = this.implementedRequestCount * 100 / (this.implementedRequestCount + this.missingRequestCount);
        sb.append("\t\tImplemented:\t").append(String.valueOf(percentage)).append("% [# ").append(this.implementedRequestCount).append("]\t Missing: ");
        percentage = this.missingRequestCount * 100 / (this.implementedRequestCount + this.missingRequestCount);
        sb.append(String.valueOf(percentage)).append("% [# ").append(this.missingRequestCount).append("]");
        return sb.toString();
    }
}

