/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import java.util.List;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestSiteContainerModel;
import org.alfresco.rest.model.RestSiteContainerModelsCollection;
import org.alfresco.rest.model.RestSiteGroupModel;
import org.alfresco.rest.model.RestSiteGroupModelsCollection;
import org.alfresco.rest.model.RestSiteMemberModel;
import org.alfresco.rest.model.RestSiteMemberModelsCollection;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestSiteModelsCollection;
import org.alfresco.rest.model.RestSitePersonMembershipRequestModelsCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.http.HttpMethod;

public class Site
extends ModelRequest<Site> {
    private SiteModel site;

    public Site(SiteModel site, RestWrapper restWrapper) {
        super(restWrapper);
        this.site = site;
    }

    public RestSiteModel getSite() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "sites/{siteId}?{parameters}", this.site.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSiteModel.class, request);
    }

    public List<Object> getSiteWithRelations() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "sites/{siteId}?{parameters}", this.site.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processRelationsJson(request);
    }

    public RestSiteModelsCollection getSites() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "sites?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSiteModelsCollection.class, request);
    }

    public List<List<Object>> getSitesWithRelations() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "sites?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processSitesRelationsJson(request);
    }

    public RestSiteMemberModel addPerson(UserModel person) {
        String siteMemberBody = JsonBodyGenerator.siteMember(person);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, siteMemberBody, "sites/{siteId}/members?{parameters}", this.site.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSiteMemberModel.class, request);
    }

    public RestSiteMemberModelsCollection getSiteMembers() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "sites/{siteId}/members?{parameters}", this.site.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSiteMemberModelsCollection.class, request);
    }

    public RestSiteMemberModel getSiteMember(UserModel user) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "sites/{siteId}/members/{personId}?{parameters}", this.site.getId(), user.getUsername(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSiteMemberModel.class, request);
    }

    public RestSiteMemberModel updateSiteMember(UserModel siteMember) {
        String json = JsonBodyGenerator.keyValueJson("role", siteMember.getUserRole().toString());
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, json, "sites/{siteId}/members/{personId}", this.site.getId(), siteMember.getUsername());
        return this.restWrapper.processModel(RestSiteMemberModel.class, request);
    }

    public void deleteSiteMember(UserModel person) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "sites/{siteId}/members/{personId}", this.site.getId(), person.getUsername());
        this.restWrapper.processEmptyModel(request);
    }

    public RestSiteContainerModelsCollection getSiteContainers() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "sites/{siteId}/containers?{parameters}", this.site.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSiteContainerModelsCollection.class, request);
    }

    public RestSiteContainerModel getSiteContainer(RestSiteContainerModel container) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "sites/{siteId}/containers/{containerId}?{parameters}", this.site.getId(), container.getFolderId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSiteContainerModel.class, request);
    }

    public RestSiteContainerModel getSiteContainer(String containerFolder) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "sites/{siteId}/containers/{containerId}?{parameters}", this.site.getId(), containerFolder, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSiteContainerModel.class, request);
    }

    public RestSiteModel createSite() {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, this.site.toJson(), "sites?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSiteModel.class, request);
    }

    public RestSiteModel updateSite(SiteModel site) {
        String siteBody = JsonBodyGenerator.updateSiteRequest(site);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, siteBody, "sites/{siteId}", site.getId());
        return this.restWrapper.processModel(RestSiteModel.class, request);
    }

    public RestSitePersonMembershipRequestModelsCollection getSiteMemberships() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "site-membership-requests?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSitePersonMembershipRequestModelsCollection.class, request);
    }

    public RestResponse approveSiteMembership(UserModel siteMember) {
        String json = JsonBodyGenerator.keyValueJson("role", siteMember.getUserRole().toString());
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, json, "sites/{siteId}/site-membership-requests/{inviteeId}/approve", this.site.getId(), siteMember.getUsername());
        return this.restWrapper.process(request);
    }

    public RestResponse rejectSiteMembership(UserModel siteMember) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.POST, "sites/{siteId}/site-membership-requests/{inviteeId}/reject", this.site.getId(), siteMember.getUsername());
        return this.restWrapper.process(request);
    }

    public RestSiteGroupModelsCollection getSiteGroups() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "sites/{siteId}/group-members?{parameters}", this.site.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSiteGroupModelsCollection.class, request);
    }

    public RestSiteGroupModel addSiteGroup(String authorityId, UserRole role) {
        String siteMemberBody = JsonBodyGenerator.siteGroup(authorityId, role);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, siteMemberBody, "sites/{siteId}/group-members?{parameters}", this.site.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSiteGroupModel.class, request);
    }

    public RestSiteGroupModel getSiteGroup(String groupId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "sites/{siteId}/group-members/{groupId}", this.site.getId(), groupId);
        return this.restWrapper.processModel(RestSiteGroupModel.class, request);
    }

    public RestSiteGroupModel updateSiteGroup(String groupId, UserRole role) {
        String json = JsonBodyGenerator.keyValueJson("role", role.toString());
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, json, "sites/{siteId}/group-members/{groupId}", this.site.getId(), groupId);
        return this.restWrapper.processModel(RestSiteGroupModel.class, request);
    }

    public void deleteSiteGroup(String groupId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "sites/{siteId}/group-members/{groupId}", this.site.getId(), groupId);
        this.restWrapper.processEmptyModel(request);
    }
}

