/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests.modelAPI;

import io.restassured.RestAssured;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestAspectModel;
import org.alfresco.rest.model.RestAspectsCollection;
import org.alfresco.rest.model.RestTypeModel;
import org.alfresco.rest.model.RestTypesCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.springframework.http.HttpMethod;

public class RestModelAPI
extends ModelRequest<RestModelAPI> {
    public RestModelAPI(RestWrapper restWrapper) {
        super(restWrapper);
        RestAssured.basePath = "alfresco/api/-default-/public/alfresco/versions/1";
        restWrapper.configureRequestSpec().setBasePath(RestAssured.basePath);
    }

    public RestAspectsCollection getAspects() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "aspects?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestAspectsCollection.class, request);
    }

    public RestAspectModel getAspect(String aspectId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "aspects/{aspectId}?{parameters}", aspectId, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestAspectModel.class, request);
    }

    public RestTypesCollection getTypes() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "types?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestTypesCollection.class, request);
    }

    public RestTypeModel getType(String typeId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "types/{typeId}?{parameters}", typeId, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestTypeModel.class, request);
    }
}

