/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import org.alfresco.rest.core.RestProperties;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;

public class Tenant
extends ModelRequest<Tenant> {
    private RestProperties restProperties;

    public Tenant(RestWrapper restWrapper, RestProperties restProperties) {
        super(restWrapper);
        this.restProperties = restProperties;
    }

    public void createTenant(UserModel userModel) {
        Step.STEP((String)String.format("DATAPREP: Create new tenant %s", userModel.getDomain()));
        String json = String.format("{\"tenantDomain\": \"%s\", \"tenantAdminPassword\": \"%s\"}", userModel.getDomain(), DataUser.PASSWORD);
        RequestSpecification request = RestAssured.given().auth().basic(this.restWrapper.getTestUser().getUsername(), this.restWrapper.getTestUser().getPassword()).contentType(ContentType.JSON);
        Response returnedResponse = (Response)((Response)request.contentType(ContentType.JSON).body(json).post(String.format("%s/%s", this.restProperties.envProperty().getFullServerUrl(), "alfresco/service/api/tenants"), new Object[0])).andReturn();
        if (!Integer.valueOf(returnedResponse.getStatusCode()).equals(HttpStatus.OK.value())) {
            throw new IllegalStateException(String.format("Tenant is not created: %s", returnedResponse.asString()));
        }
    }
}

